/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.thirdparty;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.thirdparty.ICU4JFeature;
import java.util.ArrayList;
import java.util.List;

@TargetClass(className="com.ibm.icu.impl.ICUBinary", onlyWith={ICU4JFeature.IsEnabled.class})
final class Target_com_ibm_icu_impl_ICUBinary {
    @Alias
    @InjectAccessors(value=IcuDataFilesAccessors.class)
    static List<?> icuDataFiles;

    Target_com_ibm_icu_impl_ICUBinary() {
    }

    @Alias
    static native void addDataFilesFromPath(String var0, List<?> var1);

    static final class IcuDataFilesAccessors {
        private static final String ICU4J_DATA_PATH_SYS_PROP = "com.ibm.icu.impl.ICUBinary.dataPath";
        private static final String ICU4J_DATA_PATH_ENV_VAR = "ICU4J_DATA_PATH";
        private static final String NO_DATA_PATH_ERR_MSG = "No ICU4J data path was set or found. This will likely end up with a MissingResourceException. To take advantage of the ICU4J library, you should either set system property, com.ibm.icu.impl.ICUBinary.dataPath, or set environment variable, ICU4J_DATA_PATH, to contain path to your ICU4J icudt directory";
        private static volatile List<?> instance;

        IcuDataFilesAccessors() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static List<?> get() {
            if (instance != null) return instance;
            Class<IcuDataFilesAccessors> clazz = IcuDataFilesAccessors.class;
            synchronized (IcuDataFilesAccessors.class) {
                if (instance != null) return instance;
                instance = new ArrayList();
                String dataPath = System.getProperty(ICU4J_DATA_PATH_SYS_PROP);
                if (dataPath == null || dataPath.isEmpty()) {
                    dataPath = System.getenv(ICU4J_DATA_PATH_ENV_VAR);
                }
                if (dataPath != null && !dataPath.isEmpty()) {
                    Target_com_ibm_icu_impl_ICUBinary.addDataFilesFromPath(dataPath, instance);
                } else {
                    System.err.println(NO_DATA_PATH_ERR_MSG);
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        static void set(List<?> bummer) {
        }
    }
}

