/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.contrib.javanica.utils;

import com.google.common.collect.TreeTraverser;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.Validate;

public final class TypeHelper {
    private TypeHelper() {
    }

    public static boolean isReturnTypeParametrized(Method method) {
        return method.getGenericReturnType() instanceof ParameterizedType;
    }

    @ParametersAreNonnullByDefault
    public static List<Type> getAllParameterizedTypes(Type type) {
        Validate.notNull((Object)type, (String)"type cannot be null", (Object[])new Object[0]);
        ArrayList<Type> types = new ArrayList<Type>();
        TreeTraverser<Type> typeTraverser = new TreeTraverser<Type>(){

            public Iterable<Type> children(Type root) {
                if (root instanceof ParameterizedType) {
                    ParameterizedType pType = (ParameterizedType)root;
                    return Arrays.asList(pType.getActualTypeArguments());
                }
                return Collections.emptyList();
            }
        };
        for (Type t : typeTraverser.breadthFirstTraversal((Object)type)) {
            types.add(t);
        }
        return types;
    }
}

