/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.models;

import com.microsoft.windowsazure.services.media.entityoperations.DefaultDeleteOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultListOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityCreateOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityDeleteOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityLinkOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityOperationSingleResultBase;
import com.microsoft.windowsazure.services.media.entityoperations.EntityUnlinkOperation;
import com.microsoft.windowsazure.services.media.implementation.content.ContentKeyAuthorizationPolicyType;
import com.microsoft.windowsazure.services.media.models.ContentKeyAuthorizationPolicyInfo;
import com.microsoft.windowsazure.services.media.models.LinkInfo;
import com.microsoft.windowsazure.services.media.models.ListResult;
import com.sun.jersey.api.client.GenericType;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.security.InvalidParameterException;

public final class ContentKeyAuthorizationPolicy {
    private static final String ENTITY_SET = "ContentKeyAuthorizationPolicies";

    private ContentKeyAuthorizationPolicy() {
    }

    public static EntityCreateOperation<ContentKeyAuthorizationPolicyInfo> create(String name) {
        return new Creator(name);
    }

    public static EntityGetOperation<ContentKeyAuthorizationPolicyInfo> get(String contentKeyAuthorizationPolicyId) {
        return new DefaultGetOperation<ContentKeyAuthorizationPolicyInfo>(ENTITY_SET, contentKeyAuthorizationPolicyId, ContentKeyAuthorizationPolicyInfo.class);
    }

    public static EntityGetOperation<ContentKeyAuthorizationPolicyInfo> get(LinkInfo<ContentKeyAuthorizationPolicyInfo> link) {
        return new DefaultGetOperation<ContentKeyAuthorizationPolicyInfo>(link.getHref(), ContentKeyAuthorizationPolicyInfo.class);
    }

    public static DefaultListOperation<ContentKeyAuthorizationPolicyInfo> list() {
        return new DefaultListOperation<ContentKeyAuthorizationPolicyInfo>(ENTITY_SET, new GenericType<ListResult<ContentKeyAuthorizationPolicyInfo>>(){});
    }

    public static EntityDeleteOperation delete(String contentKeyAuthorizationPolicyId) {
        return new DefaultDeleteOperation(ENTITY_SET, contentKeyAuthorizationPolicyId);
    }

    public static EntityLinkOperation linkOptions(String contentKeyAuthorizationPolicyId, String contentKeyAuthorizationPolicyOptionId) {
        String escapedContentKeyId = null;
        try {
            escapedContentKeyId = URLEncoder.encode(contentKeyAuthorizationPolicyOptionId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidParameterException("contentKeyId");
        }
        URI contentKeyUri = URI.create(String.format("ContentKeyAuthorizationPolicyOptions('%s')", escapedContentKeyId));
        return new EntityLinkOperation(ENTITY_SET, contentKeyAuthorizationPolicyId, "Options", contentKeyUri);
    }

    public static EntityUnlinkOperation unlinkOptions(String contentKeyAuthorizationPolicyId, String contentKeyAuthorizationPolicyOptionId) {
        return new EntityUnlinkOperation(ENTITY_SET, contentKeyAuthorizationPolicyId, "Options", contentKeyAuthorizationPolicyOptionId);
    }

    private static class Creator
    extends EntityOperationSingleResultBase<ContentKeyAuthorizationPolicyInfo>
    implements EntityCreateOperation<ContentKeyAuthorizationPolicyInfo> {
        private String name;

        public Creator(String name) {
            super(ContentKeyAuthorizationPolicy.ENTITY_SET, ContentKeyAuthorizationPolicyInfo.class);
            this.name = name;
        }

        @Override
        public Object getRequestContents() {
            return new ContentKeyAuthorizationPolicyType().setName(this.name);
        }
    }
}

