/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.upload;

import com.jfinal.kit.LogKit;
import com.jfinal.kit.PathKit;
import com.jfinal.kit.StrKit;
import com.jfinal.upload.MultipartRequest;
import com.oreilly.servlet.multipart.FileRenamePolicy;
import java.io.File;

public class OreillyCos {
    public static void init(String uploadPath, int maxPostSize, String encoding) {
        if (StrKit.isBlank(uploadPath)) {
            throw new IllegalArgumentException("uploadPath can not be blank.");
        }
        try {
            Class.forName("com.oreilly.servlet.MultipartRequest");
            OreillyCos.doInit(uploadPath, maxPostSize, encoding);
        }
        catch (ClassNotFoundException e) {
            LogKit.logNothing(e);
        }
    }

    public static void setFileRenamePolicy(FileRenamePolicy fileRenamePolicy) {
        if (fileRenamePolicy == null) {
            throw new IllegalArgumentException("fileRenamePolicy can not be null.");
        }
        MultipartRequest.fileRenamePolicy = fileRenamePolicy;
    }

    private static void doInit(String uploadPath, int maxPostSize, String encoding) {
        uploadPath = uploadPath.trim();
        String baseUploadPath = PathKit.isAbsolutePath(uploadPath = uploadPath.replaceAll("\\\\", "/")) ? uploadPath : PathKit.getWebRootPath() + File.separator + uploadPath;
        if (!baseUploadPath.equals("/") && baseUploadPath.endsWith("/")) {
            baseUploadPath = baseUploadPath.substring(0, baseUploadPath.length() - 1);
        }
        MultipartRequest.init(baseUploadPath, maxPostSize, encoding);
    }
}

