/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.io;

import com.jfinal.template.io.FloatingWriter;
import com.jfinal.template.io.IWritable;
import com.jfinal.template.io.IntegerWriter;
import com.jfinal.template.io.LongWriter;
import com.jfinal.template.io.Writer;
import java.io.IOException;

public class CharWriter
extends Writer {
    java.io.Writer out;
    char[] chars;
    private static final char[] TRUE_CHARS = "true".toCharArray();
    private static final char[] FALSE_CHARS = "false".toCharArray();

    public CharWriter(int bufferSize) {
        this.chars = new char[bufferSize];
    }

    public CharWriter init(java.io.Writer writer) {
        this.out = writer;
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() {
        try {
            if (this.out != null) {
                this.out.flush();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.out = null;
        }
    }

    @Override
    public void write(String str, int offset, int len) throws IOException {
        while (len > this.chars.length) {
            this.write(str, offset, this.chars.length);
            offset += this.chars.length;
            len -= this.chars.length;
        }
        str.getChars(offset, offset + len, this.chars, 0);
        this.out.write(this.chars, 0, len);
    }

    @Override
    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    @Override
    public void write(StringBuilder stringBuilder, int offset, int len) throws IOException {
        while (len > this.chars.length) {
            this.write(stringBuilder, offset, this.chars.length);
            offset += this.chars.length;
            len -= this.chars.length;
        }
        stringBuilder.getChars(offset, offset + len, this.chars, 0);
        this.out.write(this.chars, 0, len);
    }

    @Override
    public void write(StringBuilder stringBuilder) throws IOException {
        this.write(stringBuilder, 0, stringBuilder.length());
    }

    @Override
    public void write(IWritable writable) throws IOException {
        char[] data = writable.getChars();
        this.out.write(data, 0, data.length);
    }

    @Override
    public void write(int intValue) throws IOException {
        IntegerWriter.write(this, intValue);
    }

    @Override
    public void write(long longValue) throws IOException {
        LongWriter.write(this, longValue);
    }

    @Override
    public void write(double doubleValue) throws IOException {
        FloatingWriter.write(this, doubleValue);
    }

    @Override
    public void write(float floatValue) throws IOException {
        FloatingWriter.write(this, floatValue);
    }

    @Override
    public void write(boolean booleanValue) throws IOException {
        this.out.write(booleanValue ? TRUE_CHARS : FALSE_CHARS);
    }
}

