/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord.tx;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.Db;
import com.jfinal.plugin.activerecord.DbKit;
import com.jfinal.plugin.activerecord.IAtom;
import com.jfinal.plugin.activerecord.tx.Tx;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public class TxByActionKeys
implements Interceptor {
    private Set<String> actionKeySet = new HashSet<String>();

    public TxByActionKeys(String ... actionKeys) {
        if (actionKeys == null || actionKeys.length == 0) {
            throw new IllegalArgumentException("actionKeys can not be blank.");
        }
        for (String actionKey : actionKeys) {
            this.actionKeySet.add(actionKey.trim());
        }
    }

    @Override
    public void intercept(final Invocation inv) {
        Config config = Tx.getConfigWithTxConfig(inv);
        if (config == null) {
            config = DbKit.getConfig();
        }
        if (this.actionKeySet.contains(inv.getActionKey())) {
            Db.use(config.getName()).tx(new IAtom(){

                @Override
                public boolean run() throws SQLException {
                    inv.invoke();
                    return true;
                }
            });
        } else {
            inv.invoke();
        }
    }
}

