/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aggregation.impl;

import com.hazelcast.aggregation.Aggregator;
import com.hazelcast.aggregation.impl.AbstractAggregator;
import com.hazelcast.aggregation.impl.AggregatorDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public final class MaxAggregator<I, R extends Comparable>
extends AbstractAggregator<I, R>
implements IdentifiedDataSerializable {
    private R max;

    public MaxAggregator() {
    }

    public MaxAggregator(String attributePath) {
        super(attributePath);
    }

    @Override
    public void accumulate(I entry) {
        Comparable extractedValue = (Comparable)this.extract(entry);
        if (this.isCurrentlyLessThan(extractedValue)) {
            this.max = extractedValue;
        }
    }

    private boolean isCurrentlyLessThan(R extractedValue) {
        if (extractedValue == null) {
            return false;
        }
        return this.max == null || this.max.compareTo(extractedValue) < 0;
    }

    @Override
    public void combine(Aggregator aggregator) {
        MaxAggregator maxAggregator = (MaxAggregator)aggregator;
        R valueFromOtherAggregator = maxAggregator.max;
        if (this.isCurrentlyLessThan(valueFromOtherAggregator)) {
            this.max = valueFromOtherAggregator;
        }
    }

    @Override
    public R aggregate() {
        return this.max;
    }

    @Override
    public int getFactoryId() {
        return AggregatorDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 14;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.attributePath);
        out.writeObject(this.max);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.attributePath = in.readUTF();
        this.max = (Comparable)in.readObject();
    }
}

