/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.internal.metrics.MetricsProvider;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.impl.operationservice.impl.CallIdSequence;
import com.hazelcast.spi.impl.operationservice.impl.Invocation;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class InvocationRegistry
implements Iterable<Invocation>,
MetricsProvider {
    private static final int INITIAL_CAPACITY = 1000;
    private static final float LOAD_FACTOR = 0.75f;
    private static final double HUNDRED_PERCENT = 100.0;
    @Probe(name="invocations.pending", level=ProbeLevel.MANDATORY)
    private final ConcurrentMap<Long, Invocation> invocations;
    private final ILogger logger;
    private final CallIdSequence callIdSequence;
    private volatile boolean alive = true;

    public InvocationRegistry(ILogger logger, CallIdSequence callIdSequence, int concurrencyLevel) {
        this.logger = logger;
        this.callIdSequence = callIdSequence;
        this.invocations = new ConcurrentHashMap<Long, Invocation>(1000, 0.75f, concurrencyLevel);
    }

    @Override
    public void provideMetrics(MetricsRegistry metricsRegistry) {
        metricsRegistry.scanAndRegister(this, "operation");
    }

    @Probe(name="invocations.usedPercentage")
    private double invocationsUsedPercentage() {
        int maxConcurrentInvocations = this.callIdSequence.getMaxConcurrentInvocations();
        if (maxConcurrentInvocations == Integer.MAX_VALUE) {
            return 0.0;
        }
        return 100.0 * (double)this.invocations.size() / (double)maxConcurrentInvocations;
    }

    @Probe(name="invocations.lastCallId")
    long getLastCallId() {
        return this.callIdSequence.getLastCallId();
    }

    public boolean register(Invocation invocation) {
        assert (invocation.op.getCallId() == 0L) : "can't register twice: " + invocation;
        long callId = this.callIdSequence.next(invocation);
        OperationAccessor.setCallId(invocation.op, callId);
        this.invocations.put(callId, invocation);
        if (!this.alive) {
            invocation.notifyError(new HazelcastInstanceNotActiveException());
            return false;
        }
        return true;
    }

    public void deregister(Invocation invocation) {
        boolean deleted;
        long callId = invocation.op.getCallId();
        this.callIdSequence.complete(invocation);
        OperationAccessor.setCallId(invocation.op, 0L);
        if (callId == 0L) {
            return;
        }
        boolean bl = deleted = this.invocations.remove(callId) != null;
        if (!deleted && this.logger.isFinestEnabled()) {
            this.logger.finest("failed to deregister callId: " + callId + " " + invocation);
        }
    }

    public int size() {
        return this.invocations.size();
    }

    @Override
    public Iterator<Invocation> iterator() {
        return this.invocations.values().iterator();
    }

    public Set<Map.Entry<Long, Invocation>> entrySet() {
        return this.invocations.entrySet();
    }

    public Invocation get(long callId) {
        return (Invocation)this.invocations.get(callId);
    }

    public void reset() {
        for (Invocation invocation : this) {
            try {
                invocation.notifyError(new MemberLeftException());
            }
            catch (Throwable e) {
                this.logger.warning(invocation + " could not be notified with reset message -> " + e.getMessage());
            }
        }
    }

    public void shutdown() {
        this.alive = false;
        for (Invocation invocation : this) {
            try {
                invocation.notifyError(new HazelcastInstanceNotActiveException());
            }
            catch (Throwable e) {
                this.logger.warning(invocation + " could not be notified with shutdown message -> " + e.getMessage(), e);
            }
        }
    }
}

