/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.DuplicateDetectingMultiResult;
import com.hazelcast.query.impl.FastMultiResultSet;
import com.hazelcast.query.impl.IndexImpl;
import com.hazelcast.query.impl.IndexStore;
import com.hazelcast.query.impl.MultiResultSet;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.TypeConverters;
import com.hazelcast.query.impl.getters.MultiResult;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class BaseIndexStore
implements IndexStore {
    protected static final float LOAD_FACTOR = 0.75f;
    protected ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    protected ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private boolean multiResultHasToDetectDuplicates;

    abstract void newIndexInternal(Comparable var1, QueryableEntry var2);

    abstract void removeIndexInternal(Comparable var1, Data var2);

    @Override
    public final void newIndex(Object newValue, QueryableEntry record) {
        this.takeWriteLock();
        try {
            this.unwrapAndAddToIndex(newValue, record);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void unwrapAndAddToIndex(Object newValue, QueryableEntry record) {
        if (newValue instanceof MultiResult) {
            this.multiResultHasToDetectDuplicates = true;
            List results = ((MultiResult)newValue).getResults();
            for (Object o : results) {
                Comparable sanitizedValue = this.sanitizeValue(o);
                this.newIndexInternal(sanitizedValue, record);
            }
        } else {
            Comparable sanitizedValue = this.sanitizeValue(newValue);
            this.newIndexInternal(sanitizedValue, record);
        }
    }

    @Override
    public final void removeIndex(Object oldValue, Data indexKey) {
        this.takeWriteLock();
        try {
            this.unwrapAndRemoveFromIndex(oldValue, indexKey);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void unwrapAndRemoveFromIndex(Object oldValue, Data indexKey) {
        if (oldValue instanceof MultiResult) {
            List results = ((MultiResult)oldValue).getResults();
            for (Object o : results) {
                Comparable sanitizedValue = this.sanitizeValue(o);
                this.removeIndexInternal(sanitizedValue, indexKey);
            }
        } else {
            Comparable sanitizedValue = this.sanitizeValue(oldValue);
            this.removeIndexInternal(sanitizedValue, indexKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void updateIndex(Object oldValue, Object newValue, QueryableEntry entry) {
        this.takeWriteLock();
        try {
            Data indexKey = entry.getKeyData();
            this.unwrapAndRemoveFromIndex(oldValue, indexKey);
            this.unwrapAndAddToIndex(newValue, entry);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    void takeWriteLock() {
        this.writeLock.lock();
    }

    void releaseWriteLock() {
        this.writeLock.unlock();
    }

    protected void takeReadLock() {
        this.readLock.lock();
    }

    protected void releaseReadLock() {
        this.readLock.unlock();
    }

    private Comparable sanitizeValue(Object input) {
        if (input == null || input instanceof Comparable) {
            Comparable value = (Comparable)input;
            if (value == null) {
                value = IndexImpl.NULL;
            } else if (value.getClass().isEnum()) {
                value = TypeConverters.ENUM_CONVERTER.convert(value);
            }
            return value;
        }
        throw new IllegalArgumentException("It is not allowed to used a type that is not Comparable: " + input.getClass());
    }

    protected MultiResultSet createMultiResultSet() {
        return (MultiResultSet)((Object)(this.multiResultHasToDetectDuplicates ? new DuplicateDetectingMultiResult() : new FastMultiResultSet()));
    }
}

