/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.nearcache;

import com.hazelcast.cache.impl.nearcache.NearCache;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.map.impl.SizeEstimator;
import com.hazelcast.map.impl.nearcache.NearCacheRecord;
import com.hazelcast.monitor.impl.NearCacheStatsImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class NearCacheImpl
implements NearCache<Data, Object> {
    public static final String NEAR_CACHE_EXECUTOR_NAME = "hz:near-cache";
    private static final double EVICTION_FACTOR = 0.2;
    private static final int CLEANUP_INTERVAL = 5000;
    private final int maxSize;
    private final String mapName;
    private final long maxIdleMillis;
    private final long timeToLiveMillis;
    private final EvictionPolicy evictionPolicy;
    private final InMemoryFormat inMemoryFormat;
    private final NodeEngine nodeEngine;
    private final AtomicBoolean canCleanUp;
    private final AtomicBoolean canEvict;
    private final ConcurrentMap<Data, NearCacheRecord> cache;
    private final NearCacheStatsImpl nearCacheStats;
    private final SerializationService serializationService;
    private final Comparator<NearCacheRecord> selectedComparator;
    private final boolean invalidateOnChange;
    private SizeEstimator nearCacheSizeEstimator;
    private volatile long lastCleanup;

    public NearCacheImpl(String mapName, NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        Config config = nodeEngine.getConfig();
        NearCacheConfig nearCacheConfig = config.findMapConfig(mapName).getNearCacheConfig();
        this.maxSize = nearCacheConfig.getMaxSize() <= 0 ? Integer.MAX_VALUE : nearCacheConfig.getMaxSize();
        this.maxIdleMillis = TimeUnit.SECONDS.toMillis(nearCacheConfig.getMaxIdleSeconds());
        this.inMemoryFormat = nearCacheConfig.getInMemoryFormat();
        this.timeToLiveMillis = TimeUnit.SECONDS.toMillis(nearCacheConfig.getTimeToLiveSeconds());
        this.evictionPolicy = EvictionPolicy.valueOf(nearCacheConfig.getEvictionPolicy());
        this.selectedComparator = NearCacheRecord.getComparator(this.evictionPolicy);
        this.cache = new ConcurrentHashMap<Data, NearCacheRecord>();
        this.canCleanUp = new AtomicBoolean(true);
        this.canEvict = new AtomicBoolean(true);
        this.nearCacheStats = new NearCacheStatsImpl();
        this.lastCleanup = Clock.currentTimeMillis();
        this.serializationService = nodeEngine.getSerializationService();
        this.invalidateOnChange = nearCacheConfig.isInvalidateOnChange();
        this.mapName = mapName;
    }

    @Override
    public void put(Data key, Object value) {
        this.fireTtlCleanup();
        if (this.evictionPolicy == EvictionPolicy.NONE && this.cache.size() >= this.maxSize) {
            return;
        }
        if (this.evictionPolicy != EvictionPolicy.NONE && this.cache.size() >= this.maxSize) {
            this.fireEvictCache();
        }
        value = value == null ? NULL_OBJECT : (this.inMemoryFormat.equals((Object)InMemoryFormat.OBJECT) ? this.serializationService.toObject(value) : this.serializationService.toData(value));
        NearCacheRecord record = new NearCacheRecord(key, value);
        NearCacheRecord previous = this.cache.put(key, record);
        this.updateSizeEstimator(this.calculateCost(record));
        if (previous != null) {
            this.updateSizeEstimator(-this.calculateCost(previous));
        }
    }

    @Override
    public NearCacheStatsImpl getNearCacheStats() {
        return this.createNearCacheStats();
    }

    @Override
    public Object selectToSave(Object ... candidates) {
        throw new UnsupportedOperationException();
    }

    private NearCacheStatsImpl createNearCacheStats() {
        long ownedEntryCount = 0L;
        long ownedEntryMemoryCost = 0L;
        for (NearCacheRecord record : this.cache.values()) {
            ++ownedEntryCount;
            ownedEntryMemoryCost += record.getCost();
        }
        this.nearCacheStats.setOwnedEntryCount(ownedEntryCount);
        this.nearCacheStats.setOwnedEntryMemoryCost(ownedEntryMemoryCost);
        return this.nearCacheStats;
    }

    private void fireEvictCache() {
        if (this.canEvict.compareAndSet(true, false)) {
            try {
                final ExecutionService executionService = this.nodeEngine.getExecutionService();
                executionService.execute(NEAR_CACHE_EXECUTOR_NAME, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            TreeSet records = new TreeSet(NearCacheImpl.this.selectedComparator);
                            records.addAll(NearCacheImpl.this.cache.values());
                            int evictSize = (int)((double)NearCacheImpl.this.cache.size() * 0.2);
                            int i = 0;
                            for (NearCacheRecord record : records) {
                                NearCacheImpl.this.cache.remove(record.getKey());
                                NearCacheImpl.this.updateSizeEstimator(-NearCacheImpl.this.calculateCost(record));
                                if (++i <= evictSize) continue;
                                break;
                            }
                        }
                        finally {
                            NearCacheImpl.this.canEvict.set(true);
                        }
                        if (NearCacheImpl.this.cache.size() >= NearCacheImpl.this.maxSize && NearCacheImpl.this.canEvict.compareAndSet(true, false)) {
                            try {
                                executionService.execute(NearCacheImpl.NEAR_CACHE_EXECUTOR_NAME, this);
                            }
                            catch (RejectedExecutionException e) {
                                NearCacheImpl.this.canEvict.set(true);
                            }
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                this.canEvict.set(true);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
    }

    private void fireTtlCleanup() {
        if (Clock.currentTimeMillis() < this.lastCleanup + 5000L) {
            return;
        }
        if (this.canCleanUp.compareAndSet(true, false)) {
            try {
                this.nodeEngine.getExecutionService().execute(NEAR_CACHE_EXECUTOR_NAME, new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            NearCacheImpl.this.lastCleanup = Clock.currentTimeMillis();
                            for (Map.Entry entry : NearCacheImpl.this.cache.entrySet()) {
                                if (!((NearCacheRecord)entry.getValue()).isExpired(NearCacheImpl.this.maxIdleMillis, NearCacheImpl.this.timeToLiveMillis)) continue;
                                Data key = (Data)entry.getKey();
                                NearCacheRecord record = (NearCacheRecord)NearCacheImpl.this.cache.remove(key);
                                if (record == null) continue;
                                NearCacheImpl.this.updateSizeEstimator(-NearCacheImpl.this.calculateCost(record));
                            }
                        }
                        finally {
                            NearCacheImpl.this.canCleanUp.set(true);
                        }
                    }
                });
            }
            catch (RejectedExecutionException e) {
                this.canCleanUp.set(true);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
    }

    @Override
    public String getName() {
        return this.mapName;
    }

    @Override
    public Object get(Data key) {
        this.fireTtlCleanup();
        NearCacheRecord record = (NearCacheRecord)this.cache.get(key);
        if (record != null) {
            if (record.isExpired(this.maxIdleMillis, this.timeToLiveMillis)) {
                this.cache.remove(key);
                this.updateSizeEstimator(-this.calculateCost(record));
                this.nearCacheStats.incrementMisses();
                return null;
            }
            this.nearCacheStats.incrementHits();
            record.access();
            return record.getValue();
        }
        this.nearCacheStats.incrementMisses();
        return null;
    }

    @Override
    public boolean remove(Data key) {
        NearCacheRecord record = (NearCacheRecord)this.cache.remove(key);
        if (record != null) {
            this.updateSizeEstimator(-this.calculateCost(record));
            return true;
        }
        return false;
    }

    @Override
    public boolean isInvalidateOnChange() {
        return this.invalidateOnChange;
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.resetSizeEstimator();
    }

    @Override
    public void destroy() {
        this.clear();
    }

    @Override
    public InMemoryFormat getInMemoryFormat() {
        return this.inMemoryFormat;
    }

    private void resetSizeEstimator() {
        this.getNearCacheSizeEstimator().reset();
    }

    private void updateSizeEstimator(long size) {
        this.getNearCacheSizeEstimator().add(size);
    }

    private long calculateCost(NearCacheRecord record) {
        return this.getNearCacheSizeEstimator().calculateSize(record);
    }

    public SizeEstimator getNearCacheSizeEstimator() {
        return this.nearCacheSizeEstimator;
    }

    public void setNearCacheSizeEstimator(SizeEstimator nearCacheSizeEstimator) {
        this.nearCacheSizeEstimator = nearCacheSizeEstimator;
    }
}

