/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query;

import com.hazelcast.core.MapEntry;
import com.hazelcast.impl.Record;
import com.hazelcast.query.Expression;
import com.hazelcast.query.IndexStore;
import com.hazelcast.query.MultiResultSet;
import com.hazelcast.query.Predicates;
import com.hazelcast.query.SortedIndexStore;
import com.hazelcast.query.UnsortedIndexStore;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index {
    private final ConcurrentMap<Long, Long> recordValues = new ConcurrentHashMap<Long, Long>(100, 0.75f, 1);
    private final IndexStore indexStore;
    private final Expression expression;
    private final boolean ordered;
    private final int attributeIndex;
    private volatile byte returnType = (byte)-1;
    volatile boolean strong = false;
    volatile boolean checkedStrength = false;
    private static final int TYPE_STRING = 101;
    private static final int TYPE_INT = 102;
    private static final int TYPE_LONG = 103;
    private static final int TYPE_BOOLEAN = 104;
    private static final int TYPE_DOUBLE = 105;
    private static final int TYPE_FLOAT = 106;
    private static final int TYPE_BYTE = 107;
    private static final int TYPE_CLASS = 108;
    private static final int TYPE_UNKNOWN = 109;

    Index(Expression expression, boolean ordered, int attributeIndex) {
        this.expression = expression;
        this.ordered = ordered;
        this.attributeIndex = attributeIndex;
        this.indexStore = ordered ? new SortedIndexStore() : new UnsortedIndexStore();
    }

    public void index(Long newValue, Record record) {
        if (this.expression != null && this.returnType == -1) {
            this.returnType = record.getIndexTypes()[this.attributeIndex];
        }
        Long recordId = record.getId();
        Long oldValue = (Long)this.recordValues.get(recordId);
        if (record.isActive()) {
            if (oldValue == null) {
                this.newRecordIndex(newValue, record);
            } else if (!oldValue.equals(newValue)) {
                this.removeRecordIndex(oldValue, recordId);
                this.newRecordIndex(newValue, record);
            }
        } else {
            if (oldValue != null) {
                this.removeRecordIndex(oldValue, recordId);
            }
            this.recordValues.remove(recordId);
        }
    }

    public Long extractLongValue(Object value) {
        Object extractedValue = this.expression.getValue(value);
        if (extractedValue == null) {
            return Long.MAX_VALUE;
        }
        if (!this.checkedStrength) {
            if (extractedValue instanceof Boolean || extractedValue instanceof Number) {
                this.strong = true;
            }
            this.checkedStrength = true;
        }
        return Index.getLongValueByType(extractedValue);
    }

    private void newRecordIndex(Long newValue, Record record) {
        Long recordId = record.getId();
        this.indexStore.newRecordIndex(newValue, record);
        this.recordValues.put(recordId, newValue);
    }

    private void removeRecordIndex(Long oldValue, Long recordId) {
        this.recordValues.remove(recordId);
        this.indexStore.removeRecordIndex(oldValue, recordId);
    }

    public void appendState(StringBuffer sbState) {
        sbState.append("\nexp:" + this.expression + ", recordValues:" + this.recordValues.size() + ", " + this.indexStore);
    }

    public Set<MapEntry> getRecords(Set<Long> uniqueValues) {
        if (uniqueValues.size() == 1) {
            return this.indexStore.getRecords(uniqueValues.iterator().next());
        }
        MultiResultSet results = new MultiResultSet(this.recordValues);
        this.indexStore.getRecords(results, uniqueValues);
        return results;
    }

    public Set<MapEntry> getRecords(Long value) {
        return this.indexStore.getRecords(value);
    }

    public Set<MapEntry> getSubRecordsBetween(Long from, Long to) {
        MultiResultSet results = new MultiResultSet(this.recordValues);
        this.indexStore.getSubRecordsBetween(results, from, to);
        return results;
    }

    public Set<MapEntry> getSubRecords(boolean equal, boolean lessThan, Long searchedValue) {
        MultiResultSet results = new MultiResultSet(this.recordValues);
        this.indexStore.getSubRecords(results, equal, lessThan, searchedValue);
        return results;
    }

    public byte getIndexType() {
        if (this.returnType == -1) {
            Predicates.GetExpressionImpl ex = (Predicates.GetExpressionImpl)this.expression;
            this.returnType = this.getIndexType(ex.getter.getReturnType());
        }
        return this.returnType;
    }

    public byte getIndexType(Class klass) {
        if (klass == String.class) {
            return 101;
        }
        if (klass == Integer.TYPE || klass == Integer.class) {
            return 102;
        }
        if (klass == Long.TYPE || klass == Long.class) {
            return 103;
        }
        if (klass == Boolean.TYPE || klass == Boolean.class) {
            return 104;
        }
        if (klass == Double.TYPE || klass == Double.class) {
            return 105;
        }
        if (klass == Float.TYPE || klass == Float.class) {
            return 106;
        }
        if (klass == Byte.TYPE || klass == Byte.class) {
            return 107;
        }
        if (klass == Character.TYPE || klass == Character.class) {
            return 108;
        }
        return 109;
    }

    private static long getLongValueByType(Object value) {
        if (value == null) {
            return Long.MAX_VALUE;
        }
        if (value instanceof Double) {
            return Double.doubleToLongBits((Double)value);
        }
        if (value instanceof Float) {
            return Float.floatToIntBits(((Float)value).floatValue());
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof Boolean) {
            return Boolean.TRUE.equals(value) ? 1L : -1L;
        }
        if (value instanceof String) {
            return value.hashCode();
        }
        return value.hashCode();
    }

    long getLongValue(Object value) {
        if (value == null) {
            return Long.MIN_VALUE;
        }
        byte valueType = this.getIndexType(value.getClass());
        if (valueType != this.returnType && value instanceof String) {
            String str = (String)value;
            if (this.returnType == 102) {
                value = Integer.valueOf(str);
            } else if (this.returnType == 103) {
                value = Long.valueOf(str);
            } else if (this.returnType == 104) {
                value = Boolean.valueOf(str);
            } else if (this.returnType == 105) {
                value = Double.valueOf(str);
            } else if (this.returnType == 106) {
                value = Float.valueOf(str);
            } else if (this.returnType == 107) {
                value = Byte.valueOf(str);
            } else if (this.returnType == 108) {
                value = str.hashCode();
            }
        }
        return Index.getLongValueByType(value);
    }

    public int getAttributeIndex() {
        return this.attributeIndex;
    }

    ConcurrentMap<Long, Long> getRecordValues() {
        return this.recordValues;
    }

    ConcurrentMap<Long, ConcurrentMap<Long, Record>> getMapRecords() {
        return this.indexStore.getMapRecords();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isStrong() {
        return this.strong;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Index index = (Index)o;
        return this.expression.equals(index.expression);
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Index{");
        sb.append("recordValues=").append(this.recordValues.size());
        sb.append(", ").append(this.indexStore);
        sb.append(", ordered=").append(this.ordered);
        sb.append(", strong=").append(this.strong);
        sb.append(", expression=").append(this.expression);
        sb.append('}');
        return sb.toString();
    }
}

