/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.utils;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddrUtil {
    public static Map<InetSocketAddress, InetSocketAddress> getAddressMap(String s) {
        if (s == null) {
            throw new NullPointerException("Null host list");
        }
        if (s.trim().equals("")) {
            throw new IllegalArgumentException("No hosts in list:  ``" + s + "''");
        }
        s = s.trim();
        LinkedHashMap<InetSocketAddress, InetSocketAddress> result = new LinkedHashMap<InetSocketAddress, InetSocketAddress>();
        for (String hosts : s.split(" ")) {
            String[] nodes = hosts.split(",");
            if (nodes.length < 1) {
                throw new IllegalArgumentException("Invalid server ``" + hosts + "'' in list:  " + s);
            }
            String mainHost = nodes[0].trim();
            InetSocketAddress mainAddress = AddrUtil.getInetSocketAddress(s, mainHost);
            if (nodes.length >= 2) {
                InetSocketAddress standByAddress = AddrUtil.getInetSocketAddress(s, nodes[1].trim());
                result.put(mainAddress, standByAddress);
                continue;
            }
            result.put(mainAddress, null);
        }
        assert (!result.isEmpty()) : "No addrs found";
        return result;
    }

    private static InetSocketAddress getInetSocketAddress(String s, String mainHost) {
        int finalColon = mainHost.lastIndexOf(58);
        if (finalColon < 1) {
            throw new IllegalArgumentException("Invalid server ``" + mainHost + "'' in list:  " + s);
        }
        String hostPart = mainHost.substring(0, finalColon).trim();
        String portNum = mainHost.substring(finalColon + 1).trim();
        InetSocketAddress mainAddress = new InetSocketAddress(hostPart, Integer.parseInt(portNum));
        return mainAddress;
    }

    public static List<InetSocketAddress> getAddresses(String s) {
        if (s == null) {
            throw new NullPointerException("Null host list");
        }
        if (s.trim().equals("")) {
            throw new IllegalArgumentException("No hosts in list:  ``" + s + "''");
        }
        s = s.trim();
        ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>();
        for (String hoststuff : s.split(" ")) {
            int finalColon = hoststuff.lastIndexOf(58);
            if (finalColon < 1) {
                throw new IllegalArgumentException("Invalid server ``" + hoststuff + "'' in list:  " + s);
            }
            String hostPart = hoststuff.substring(0, finalColon).trim();
            String portNum = hoststuff.substring(finalColon + 1).trim();
            addrs.add(new InetSocketAddress(hostPart, Integer.parseInt(portNum)));
        }
        assert (!addrs.isEmpty()) : "No addrs found";
        return addrs;
    }

    public static InetSocketAddress getOneAddress(String server) {
        if (server == null) {
            throw new NullPointerException("Null host");
        }
        if (server.trim().equals("")) {
            throw new IllegalArgumentException("No hosts in:  ``" + server + "''");
        }
        int finalColon = (server = server.trim()).lastIndexOf(58);
        if (finalColon < 1) {
            throw new IllegalArgumentException("Invalid server ``" + server + "''");
        }
        String hostPart = server.substring(0, finalColon).trim();
        String portNum = server.substring(finalColon + 1).trim();
        return new InetSocketAddress(hostPart, Integer.parseInt(portNum));
    }

    public static boolean isEnableShutDownHook() {
        return Boolean.valueOf(System.getProperty("xmemcached.shutdown.hook.enable", "false"));
    }
}

