/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.impl;

import com.google.code.yanf4j.core.Session;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.rubyeye.xmemcached.HashAlgorithm;
import net.rubyeye.xmemcached.impl.AbstractMemcachedSessionLocator;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.networking.MemcachedSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElectionMemcachedSessionLocator
extends AbstractMemcachedSessionLocator {
    private volatile transient List<Session> sessions;
    private final HashAlgorithm hashAlgorithm;

    public ElectionMemcachedSessionLocator() {
        this.hashAlgorithm = HashAlgorithm.ELECTION_HASH;
    }

    public ElectionMemcachedSessionLocator(HashAlgorithm hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    @Override
    public Session getSessionByKey(String key) {
        ArrayList<Session> copySessionList = new ArrayList<Session>(this.sessions);
        Session result = this.getSessionByElection(key, copySessionList);
        while (!this.failureMode && (result == null || result.isClosed()) && copySessionList.size() > 0) {
            copySessionList.remove(result);
            result = this.getSessionByElection(key, copySessionList);
        }
        return result;
    }

    private Session getSessionByElection(String key, List<Session> copySessionList) {
        Session result = null;
        long highScore = 0L;
        for (Session session : copySessionList) {
            long hash = 0L;
            if (session instanceof MemcachedTCPSession) {
                MemcachedSession tcpSession = (MemcachedSession)session;
                for (int i = 0; i < tcpSession.getWeight(); ++i) {
                    hash = this.hashAlgorithm.hash(session.getRemoteSocketAddress().toString() + "-" + i + key);
                    if (hash <= highScore) continue;
                    highScore = hash;
                    result = session;
                }
            } else {
                hash = this.hashAlgorithm.hash(session.getRemoteSocketAddress().toString() + key);
            }
            if (hash <= highScore) continue;
            highScore = hash;
            result = session;
        }
        return result;
    }

    @Override
    public void updateSessions(Collection<Session> list) {
        this.sessions = new ArrayList<Session>(list);
    }
}

