/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command.text;

import com.google.code.yanf4j.buffer.IoBuffer;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.command.Command;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.networking.MemcachedSession;
import net.rubyeye.xmemcached.utils.ByteUtils;

public class TextAWSElasticCacheConfigCommand
extends Command {
    private String key;
    private String subCommand;

    public TextAWSElasticCacheConfigCommand(CountDownLatch latch, String subCommand, String key) {
        super(subCommand + key, CommandType.AWS_CONFIG, latch);
        this.key = key;
        this.subCommand = subCommand;
        this.result = new StringBuilder();
    }

    public boolean decode(MemcachedTCPSession session, ByteBuffer buffer) {
        String line = null;
        while ((line = ByteUtils.nextLine(buffer)) != null) {
            if (line.equals("END")) {
                return this.done(session);
            }
            if (line.startsWith("CONFIG")) continue;
            ((StringBuilder)this.getResult()).append(line);
        }
        return false;
    }

    private final boolean done(MemcachedSession session) {
        this.setResult(this.getResult().toString());
        this.countDownLatch();
        return true;
    }

    public void encode() {
        byte[] subCmdBytes = ByteUtils.getBytes(this.subCommand);
        byte[] keyBytes = ByteUtils.getBytes(this.key);
        this.ioBuffer = IoBuffer.allocate(7 + subCmdBytes.length + 1 + keyBytes.length + 2);
        ByteUtils.setArguments(this.ioBuffer, "config", subCmdBytes, keyBytes);
        this.ioBuffer.flip();
    }
}

