/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command.binary;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.command.AssocCommandAware;
import net.rubyeye.xmemcached.command.Command;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.command.binary.BaseBinaryCommand;
import net.rubyeye.xmemcached.command.binary.BinaryDecodeStatus;
import net.rubyeye.xmemcached.command.binary.OpCode;
import net.rubyeye.xmemcached.command.binary.ResponseStatus;
import net.rubyeye.xmemcached.transcoders.CachedData;
import net.rubyeye.xmemcached.utils.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryGetCommand
extends BaseBinaryCommand
implements AssocCommandAware {
    private String responseKey;
    private CachedData responseValue;
    private List<Command> assocCommands;

    public final String getResponseKey() {
        return this.responseKey;
    }

    public final void setResponseKey(String responseKey) {
        this.responseKey = responseKey;
    }

    public BinaryGetCommand(String key, byte[] keyBytes, CommandType cmdType, CountDownLatch latch, OpCode opCode, boolean noreply) {
        super(key, keyBytes, cmdType, latch, 0, 0L, null, noreply, null);
        this.opCode = opCode;
        this.responseValue = new CachedData();
    }

    @Override
    public final List<Command> getAssocCommands() {
        return this.assocCommands;
    }

    @Override
    public final void setAssocCommands(List<Command> assocCommands) {
        this.assocCommands = assocCommands;
    }

    @Override
    protected void readHeader(ByteBuffer buffer) {
        super.readHeader(buffer);
        if (this.responseStatus != ResponseStatus.NO_ERROR && ByteUtils.stepBuffer(buffer, this.responseTotalBodyLength)) {
            this.decodeStatus = BinaryDecodeStatus.DONE;
        }
    }

    @Override
    protected boolean finish() {
        this.countDownLatch();
        return true;
    }

    @Override
    protected boolean readKey(ByteBuffer buffer, int keyLength) {
        if (buffer.remaining() < keyLength) {
            return false;
        }
        if (keyLength > 0) {
            byte[] bytes = new byte[keyLength];
            buffer.get(bytes);
            this.responseKey = ByteUtils.getString(bytes);
        }
        return true;
    }

    @Override
    protected boolean readValue(ByteBuffer buffer, int bodyLength, int keyLength, int extrasLength) {
        if (this.responseStatus == ResponseStatus.NO_ERROR) {
            int valueLength = bodyLength - keyLength - extrasLength;
            if (valueLength >= 0 && this.responseValue.getCapacity() < 0) {
                this.responseValue.setCapacity(valueLength);
                this.responseValue.setData(new byte[valueLength]);
            }
            int remainingCapacity = this.responseValue.remainingCapacity();
            int remaining = buffer.remaining();
            if (remaining < remainingCapacity) {
                int length = remaining > remainingCapacity ? remainingCapacity : remaining;
                this.responseValue.fillData(buffer, length);
                return false;
            }
            if (remainingCapacity > 0) {
                this.responseValue.fillData(buffer, remainingCapacity);
            }
            this.setResult(this.responseValue);
            return true;
        }
        return ByteUtils.stepBuffer(buffer, bodyLength - keyLength - extrasLength);
    }

    @Override
    protected boolean readExtras(ByteBuffer buffer, int extrasLength) {
        if (buffer.remaining() < extrasLength) {
            return false;
        }
        if (extrasLength > 0) {
            int flag = buffer.getInt();
            this.responseValue.setFlag(flag);
        }
        return true;
    }

    @Override
    protected void fillExtras(CachedData data) {
    }

    @Override
    protected void fillValue(CachedData data) {
    }

    @Override
    protected byte getExtrasLength() {
        return 0;
    }

    @Override
    protected int getValueLength(CachedData data) {
        return 0;
    }

    @Override
    protected long readCAS(ByteBuffer buffer) {
        long cas = buffer.getLong();
        this.responseValue.setCas(cas);
        return cas;
    }
}

