/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command.binary;

import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.command.binary.BaseBinaryCommand;
import net.rubyeye.xmemcached.command.binary.OpCode;
import net.rubyeye.xmemcached.transcoders.CachedData;
import net.rubyeye.xmemcached.utils.ByteUtils;

public class BinaryAWSElasticCacheConfigCommand
extends BaseBinaryCommand {
    public BinaryAWSElasticCacheConfigCommand(CountDownLatch latch, String subCommand, String key) {
        super(key, ByteUtils.getBytes(key), CommandType.AWS_CONFIG, latch, 0, 0L, latch, false, null);
        this.commandType = CommandType.AWS_CONFIG;
        if (subCommand.equals("get")) {
            this.opCode = OpCode.CONFIG_GET;
        } else if (subCommand.equals("set")) {
            this.opCode = OpCode.CONFIG_SET;
        } else if (subCommand.equals("delete")) {
            this.opCode = OpCode.CONFIG_DEL;
        }
    }

    protected boolean readValue(ByteBuffer buffer, int bodyLength, int keyLength, int extrasLength) {
        int valueLength = bodyLength - keyLength - extrasLength;
        if (buffer.remaining() < valueLength) {
            return false;
        }
        byte[] bytes = new byte[valueLength];
        buffer.get(bytes);
        this.setResult(new String(bytes));
        this.countDownLatch();
        return true;
    }

    protected void fillExtras(CachedData data) {
    }

    protected void fillValue(CachedData data) {
    }

    protected byte getExtrasLength() {
        return 0;
    }

    protected int getValueLength(CachedData data) {
        return 0;
    }
}

