/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.aws;

import java.io.Serializable;
import java.net.InetSocketAddress;

public class CacheNode
implements Serializable {
    private static final long serialVersionUID = -2999058612548153786L;
    private String hostName;
    private String ipAddress;
    private int port;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hostName == null ? 0 : this.hostName.hashCode());
        result = 31 * result + this.port;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheNode other = (CacheNode)obj;
        if (this.hostName == null ? other.hostName != null : !this.hostName.equals(other.hostName)) {
            return false;
        }
        return this.port == other.port;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public InetSocketAddress getInetSocketAddress() {
        return new InetSocketAddress(this.hostName, this.port);
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String toString() {
        return "[" + this.hostName + "|" + this.ipAddress + "|" + this.port + "]";
    }

    public String getCacheKey() {
        return this.hostName + ":" + this.port;
    }

    public CacheNode(String hostName, String ipAddress, int port) {
        this.hostName = hostName;
        this.ipAddress = ipAddress;
        this.port = port;
    }
}

