/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.auth;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.auth.AuthInfo;
import net.rubyeye.xmemcached.command.Command;
import net.rubyeye.xmemcached.command.binary.BaseBinaryCommand;
import net.rubyeye.xmemcached.command.binary.ResponseStatus;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthTask
extends Thread {
    private final AuthInfo authInfo;
    private final CommandFactory commandFactory;
    private MemcachedTCPSession memcachedTCPSession;
    public static final byte[] EMPTY_BYTES = new byte[0];
    static final Logger log = LoggerFactory.getLogger(AuthTask.class);
    private SaslClient saslClient;

    public AuthTask(AuthInfo authInfo, CommandFactory commandFactory, MemcachedTCPSession memcachedTCPSession) {
        this.authInfo = authInfo;
        this.commandFactory = commandFactory;
        this.memcachedTCPSession = memcachedTCPSession;
    }

    public void run() {
        if (this.authInfo.isValid()) {
            this.doAuth();
            this.authInfo.increaseAttempts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAuth() {
        try {
            AtomicBoolean done = new AtomicBoolean(false);
            Command command = this.startAuth();
            block10: while (!done.get()) {
                this.waitCommand(command, done);
                ResponseStatus responseStatus = ((BaseBinaryCommand)command).getResponseStatus();
                switch (responseStatus) {
                    case NO_ERROR: {
                        done.set(true);
                        log.info("Authentication to " + this.memcachedTCPSession.getRemoteSocketAddress() + " successfully");
                        continue block10;
                    }
                    case AUTH_REQUIRED: {
                        log.error("Authentication failed to " + this.memcachedTCPSession.getRemoteSocketAddress());
                        log.warn("Reopen connection to " + this.memcachedTCPSession.getRemoteSocketAddress() + ",beacause auth fail");
                        this.memcachedTCPSession.setAuthFailed(true);
                        if (!this.authInfo.isFirstTime()) {
                            Thread.sleep(1000L);
                        }
                        this.memcachedTCPSession.close();
                        done.set(true);
                        continue block10;
                    }
                    case FUTHER_AUTH_REQUIRED: {
                        String result = String.valueOf(command.getResult());
                        byte[] response = this.saslClient.evaluateChallenge(ByteUtils.getBytes(result));
                        CountDownLatch latch = new CountDownLatch(1);
                        command = this.commandFactory.createAuthStepCommand(this.saslClient.getMechanismName(), latch, response);
                        if (!this.memcachedTCPSession.isClosed()) {
                            this.memcachedTCPSession.write(command);
                            continue block10;
                        }
                        log.error("Authentication fail,because the connection has been closed");
                        throw new RuntimeException("Authentication fai,connection has been close");
                    }
                }
                log.error("Authentication failed to " + this.memcachedTCPSession.getRemoteSocketAddress() + ",response status=" + (Object)((Object)responseStatus));
                command = this.startAuth();
            }
        }
        catch (Exception e) {
            log.error("Create saslClient error", (Throwable)e);
        }
        finally {
            this.destroySaslClient();
        }
    }

    private void destroySaslClient() {
        if (this.saslClient != null) {
            try {
                this.saslClient.dispose();
            }
            catch (SaslException e) {
                log.error("Dispose saslClient error", (Throwable)e);
            }
            this.saslClient = null;
        }
    }

    private Command startAuth() throws SaslException {
        this.destroySaslClient();
        this.saslClient = Sasl.createSaslClient(this.authInfo.getMechanisms(), null, "memcached", this.memcachedTCPSession.getRemoteSocketAddress().toString(), null, this.authInfo.getCallbackHandler());
        byte[] response = this.saslClient.hasInitialResponse() ? this.saslClient.evaluateChallenge(EMPTY_BYTES) : EMPTY_BYTES;
        CountDownLatch latch = new CountDownLatch(1);
        Command command = this.commandFactory.createAuthStartCommand(this.saslClient.getMechanismName(), latch, response);
        if (this.memcachedTCPSession.isClosed()) {
            log.error("Authentication fail,because the connection has been closed");
            throw new RuntimeException("Authentication fai,connection has been close");
        }
        this.memcachedTCPSession.write(command);
        return command;
    }

    private void waitCommand(Command cmd, AtomicBoolean done) {
        try {
            cmd.getLatch().await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            done.set(true);
        }
    }
}

