/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.yanf4j.util;

import com.google.code.yanf4j.buffer.IoBuffer;
import com.google.code.yanf4j.util.ByteBufferMatcher;
import com.google.code.yanf4j.util.ByteBufferUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShiftOrByteBufferMatcher
implements ByteBufferMatcher {
    private int[] b;
    private int lim;
    private int patternLen;

    public ShiftOrByteBufferMatcher(IoBuffer pat) {
        if (pat == null || pat.remaining() == 0) {
            throw new IllegalArgumentException("blank buffer");
        }
        this.patternLen = pat.remaining();
        this.preprocess(pat);
    }

    private void preprocess(IoBuffer pat) {
        int i;
        this.b = new int[256];
        this.lim = 0;
        for (i = 0; i < 256; ++i) {
            this.b[i] = -1;
        }
        i = 0;
        int j = 1;
        while (i < this.patternLen) {
            int n = ByteBufferUtils.uByte(pat.get(i));
            this.b[n] = this.b[n] & ~j;
            this.lim |= j;
            ++i;
            j <<= 1;
        }
        this.lim = ~(this.lim >> 1);
    }

    @Override
    public final List<Integer> matchAll(IoBuffer buffer) {
        ArrayList<Integer> matches = new ArrayList<Integer>();
        int bufferLimit = buffer.limit();
        int state = -1;
        for (int pos = buffer.position(); pos < bufferLimit; ++pos) {
            state <<= 1;
            if ((state |= this.b[ByteBufferUtils.uByte(buffer.get(pos))]) >= this.lim) continue;
            matches.add(pos - this.patternLen + 1);
        }
        return matches;
    }

    @Override
    public final int matchFirst(IoBuffer buffer) {
        if (buffer == null) {
            return -1;
        }
        int bufferLimit = buffer.limit();
        int state = -1;
        for (int pos = buffer.position(); pos < bufferLimit; ++pos) {
            state <<= 1;
            if ((state |= this.b[ByteBufferUtils.uByte(buffer.get(pos))]) >= this.lim) continue;
            return pos - this.patternLen + 1;
        }
        return -1;
    }
}

