/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.yanf4j.nio;

import com.google.code.yanf4j.config.Configuration;
import com.google.code.yanf4j.core.CodecFactory;
import com.google.code.yanf4j.core.EventType;
import com.google.code.yanf4j.core.Handler;
import com.google.code.yanf4j.core.impl.StandardSocketOption;
import com.google.code.yanf4j.nio.NioSession;
import com.google.code.yanf4j.nio.impl.SocketChannelController;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class TCPController
extends SocketChannelController {
    private ServerSocketChannel serverSocketChannel;
    private int backlog = 500;
    private int connectionTime;
    private int latency;
    private int bandwidth;

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        if (this.isStarted()) {
            throw new IllegalStateException();
        }
        if (backlog < 0) {
            throw new IllegalArgumentException("backlog<0");
        }
        this.backlog = backlog;
    }

    public TCPController() {
    }

    public TCPController(Configuration configuration) {
        super(configuration, null, null);
    }

    public TCPController(Configuration configuration, CodecFactory codecFactory) {
        super(configuration, null, codecFactory);
    }

    public TCPController(Configuration configuration, Handler handler, CodecFactory codecFactory) {
        super(configuration, handler, codecFactory);
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.connectionTime = connectionTime;
        this.latency = latency;
        this.bandwidth = bandwidth;
    }

    protected void doStart() throws IOException {
        this.serverSocketChannel = ServerSocketChannel.open();
        this.serverSocketChannel.socket().setSoTimeout(this.soTimeout);
        if (this.connectionTime != 0 || this.latency != 0 || this.bandwidth != 0) {
            this.serverSocketChannel.socket().setPerformancePreferences(this.connectionTime, this.latency, this.bandwidth);
        }
        this.serverSocketChannel.configureBlocking(false);
        if (this.socketOptions.get(StandardSocketOption.SO_REUSEADDR) != null) {
            this.serverSocketChannel.socket().setReuseAddress(StandardSocketOption.SO_REUSEADDR.type().cast(this.socketOptions.get(StandardSocketOption.SO_REUSEADDR)));
        }
        if (this.socketOptions.get(StandardSocketOption.SO_RCVBUF) != null) {
            this.serverSocketChannel.socket().setReceiveBufferSize(StandardSocketOption.SO_RCVBUF.type().cast(this.socketOptions.get(StandardSocketOption.SO_RCVBUF)));
        }
        if (this.localSocketAddress != null) {
            this.serverSocketChannel.socket().bind(this.localSocketAddress, this.backlog);
        } else {
            this.serverSocketChannel.socket().bind(new InetSocketAddress("localhost", 0), this.backlog);
        }
        this.setLocalSocketAddress((InetSocketAddress)this.serverSocketChannel.socket().getLocalSocketAddress());
        this.selectorManager.registerChannel(this.serverSocketChannel, 16, null);
    }

    public void onAccept(SelectionKey selectionKey) throws IOException {
        if (!this.serverSocketChannel.isOpen()) {
            selectionKey.cancel();
            return;
        }
        SocketChannel sc = null;
        try {
            sc = this.serverSocketChannel.accept();
            if (sc != null) {
                this.configureSocketChannel(sc);
                NioSession session = this.buildSession(sc);
                this.selectorManager.registerSession(session, EventType.ENABLE_READ);
                session.start();
                super.onAccept(selectionKey);
            } else {
                log.debug("Accept fail");
            }
        }
        catch (IOException e) {
            this.closeAcceptChannel(selectionKey, sc);
            log.error("Accept connection error", (Throwable)e);
            this.notifyException(e);
        }
    }

    private void closeAcceptChannel(SelectionKey sk, SocketChannel sc) throws IOException, SocketException {
        if (sk != null) {
            sk.cancel();
        }
        if (sc != null) {
            sc.socket().setSoLinger(true, 0);
            sc.socket().shutdownOutput();
            sc.close();
        }
    }

    public void closeChannel(Selector selector) throws IOException {
        if (this.serverSocketChannel != null) {
            this.serverSocketChannel.close();
        }
    }

    public void unbind() throws IOException {
        this.stop();
    }
}

