/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnjava.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.provider.svn.svnjava.util.SvnStatusHandler;
import org.codehaus.plexus.util.StringUtils;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public final class SvnJavaUtil {
    private static final long MAX_LOG_ENTRIES = 1024L;

    private SvnJavaUtil() {
    }

    public static ScmFileStatus getScmFileStatus(SVNEventAction action) {
        if (action == SVNEventAction.ADD) {
            return ScmFileStatus.ADDED;
        }
        if (action == SVNEventAction.UPDATE_ADD) {
            return ScmFileStatus.ADDED;
        }
        if (action == SVNEventAction.UPDATE_DELETE) {
            return ScmFileStatus.DELETED;
        }
        if (action == SVNEventAction.UPDATE_UPDATE) {
            return ScmFileStatus.UPDATED;
        }
        if (action == SVNEventAction.COMMIT_ADDED) {
            return ScmFileStatus.ADDED;
        }
        if (action == SVNEventAction.COMMIT_DELETED) {
            return ScmFileStatus.DELETED;
        }
        if (action == SVNEventAction.RESTORE) {
            return ScmFileStatus.UPDATED;
        }
        if (action == SVNEventAction.COMMIT_REPLACED) {
            return ScmFileStatus.CHECKED_IN;
        }
        if (action == SVNEventAction.COMMIT_MODIFIED) {
            return ScmFileStatus.CHECKED_IN;
        }
        return null;
    }

    public static void add(SVNClientManager clientManager, File wcPath, boolean recursive) throws SVNException {
        clientManager.getWCClient().doAdd(wcPath, false, false, false, recursive);
    }

    public static long checkout(SVNUpdateClient updateClient, SVNURL url, SVNRevision revision, File destPath, boolean isRecursive) throws SVNException {
        updateClient.setIgnoreExternals(false);
        return updateClient.doCheckout(url, destPath, revision, revision, isRecursive);
    }

    public static long export(SVNClientManager clientManager, SVNURL url, SVNRevision revision, File destPath, boolean isRecursive) throws SVNException {
        SVNUpdateClient updateClient = clientManager.getUpdateClient();
        updateClient.setIgnoreExternals(false);
        return updateClient.doExport(url, destPath, revision, revision, "native", true, isRecursive);
    }

    public static long switchToURL(SVNClientManager clientManager, File wcPath, SVNURL url, SVNRevision updateToRevision, boolean isRecursive) throws SVNException {
        SVNUpdateClient updateClient = clientManager.getUpdateClient();
        updateClient.setIgnoreExternals(false);
        return updateClient.doSwitch(wcPath, url, updateToRevision, isRecursive);
    }

    public static long update(SVNUpdateClient updateClient, File wcPath, SVNRevision updateToRevision, boolean isRecursive) throws SVNException {
        updateClient.setIgnoreExternals(false);
        return updateClient.doUpdate(wcPath, updateToRevision, isRecursive);
    }

    public static void changelog(SVNClientManager clientManager, SVNURL svnUrl, SVNRevision startRevision, SVNRevision endRevision, boolean stopOnCopy, boolean reportPaths, ISVNLogEntryHandler handler) throws SVNException {
        SVNLogClient logClient = clientManager.getLogClient();
        logClient.doLog(svnUrl, null, startRevision, startRevision, endRevision, stopOnCopy, reportPaths, 1024L, handler);
    }

    public static SVNCommitInfo commit(SVNCommitClient clientManager, File[] paths, boolean keepLocks, String commitMessage, boolean recursive) throws SVNException {
        return clientManager.doCommit(paths, keepLocks, commitMessage, false, recursive);
    }

    public static void delete(SVNClientManager clientManager, File[] files, boolean force) throws SVNException {
        for (int i = 0; i < files.length; ++i) {
            clientManager.getWCClient().doDelete(files[i], force, false);
        }
    }

    public static void status(SVNClientManager clientManager, File wcPath, boolean isRecursive, boolean isRemote, SvnStatusHandler handler) throws SVNException {
        boolean isIncludeIgnored = true;
        boolean isReportAll = true;
        boolean isCollectParentExternals = true;
        clientManager.getStatusClient().doStatus(wcPath, isRecursive, isRemote, isReportAll, isIncludeIgnored, isCollectParentExternals, (ISVNStatusHandler)handler);
    }

    public static SVNCommitInfo copy(SVNClientManager clientManager, SVNURL srcURL, SVNURL dstURL, boolean isMove, String commitMessage, String revision) throws SVNException {
        SVNRevision svnRevision = null;
        svnRevision = StringUtils.isEmpty((String)revision) ? SVNRevision.HEAD : SVNRevision.create((long)Long.parseLong(revision));
        SVNCopySource[] svnCopySources = new SVNCopySource[]{new SVNCopySource(svnRevision, svnRevision, srcURL)};
        return clientManager.getCopyClient().doCopy(svnCopySources, dstURL, false, true, true, commitMessage, new SVNProperties());
    }

    public static ByteArrayOutputStream diff(SVNClientManager clientManager, File baseDir, SVNRevision startRevision, SVNRevision endRevision) throws SVNException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        clientManager.getDiffClient().doDiff(baseDir, startRevision, startRevision, endRevision, true, true, (OutputStream)result);
        return result;
    }

    public static class GenericEventHandler
    implements ISVNEventHandler {
        private List events = new ArrayList();

        public void handleEvent(SVNEvent event, double progress) {
            this.events.add(event);
        }

        public void checkCancelled() throws SVNCancelException {
        }

        public List getEvents() {
            return this.events;
        }

        public void clearEvents() {
            this.events = new ArrayList();
        }
    }
}

