/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnjava.command.tag;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmTagParameters;
import org.apache.maven.scm.command.tag.AbstractTagCommand;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.SvnTagBranchUtils;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnjava.repository.SvnJavaScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnjava.util.SvnJavaUtil;
import org.codehaus.plexus.util.FileUtils;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

public class SvnTagCommand
extends AbstractTagCommand
implements SvnCommand {
    protected ScmResult executeTagCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag, String message) throws ScmException {
        return this.executeTagCommand(repo, fileSet, tag, new ScmTagParameters(message));
    }

    protected ScmResult executeTagCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag, ScmTagParameters scmTagParameters) throws ScmException {
        if (tag == null) {
            throw new ScmException("tag must be specified");
        }
        if (fileSet.getFiles().length != 0) {
            throw new ScmException("This provider doesn't support tagging subsets of a directory");
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("SVN checkout directory: " + fileSet.getBasedir().getAbsolutePath());
        }
        SvnScmProviderRepository repository = (SvnScmProviderRepository)repo;
        SvnJavaScmProviderRepository javaRepo = (SvnJavaScmProviderRepository)repo;
        try {
            SVNURL destURL = SVNURL.parseURIEncoded((String)SvnTagBranchUtils.resolveTagUrl((SvnScmProviderRepository)repository, (ScmTag)new ScmTag(tag)));
            SVNCommitInfo info = SvnJavaUtil.copy(javaRepo.getClientManager(), javaRepo.getSvnUrl(), destURL, false, "[maven-scm] copy for tag " + tag, scmTagParameters.getScmRevision());
            if (info.getError() != null) {
                return new TagScmResult("JavaSVN Library", "SVN tag failed.", info.getError().getMessage(), false);
            }
            ArrayList<ScmFile> fileList = new ArrayList<ScmFile>();
            List files = null;
            try {
                files = FileUtils.getFiles((File)fileSet.getBasedir(), (String)"**", (String)"**/.svn/**", (boolean)false);
            }
            catch (IOException e) {
                throw new ScmException("Error while building list of tagged files.", (Throwable)e);
            }
            Iterator i = files.iterator();
            while (i.hasNext()) {
                File f = (File)i.next();
                fileList.add(new ScmFile(f.getPath(), ScmFileStatus.TAGGED));
            }
            return new TagScmResult("JavaSVN Library", fileList);
        }
        catch (SVNException e) {
            return new TagScmResult("JavaSVN Library", "SVN tag failed.", e.getMessage(), false);
        }
    }
}

