/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnjava.command.remove;

import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.remove.AbstractRemoveCommand;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.svnjava.repository.SvnJavaScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnjava.util.ScmFileEventHandler;
import org.apache.maven.scm.provider.svn.svnjava.util.SvnJavaUtil;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;

public class SvnJavaRemoveCommand
extends AbstractRemoveCommand
implements SvnCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScmResult executeRemoveCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message) throws ScmException {
        if (fileSet.getFiles().length == 0) {
            throw new ScmException("You must provide at least one file/directory to remove");
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("SVN remove working directory: " + fileSet.getBasedir().getAbsolutePath());
        }
        SvnJavaScmProviderRepository javaRepo = (SvnJavaScmProviderRepository)repo;
        ScmFileEventHandler handler = new ScmFileEventHandler(this.getLogger(), fileSet.getBasedir());
        javaRepo.getClientManager().getWCClient().setEventHandler((ISVNEventHandler)handler);
        try {
            SvnJavaUtil.delete(javaRepo.getClientManager(), fileSet.getFiles(), true);
            RemoveScmResult removeScmResult = new RemoveScmResult("JavaSVN Library", handler.getFiles());
            return removeScmResult;
        }
        catch (SVNException e) {
            RemoveScmResult removeScmResult = new RemoveScmResult("JavaSVN Library", "SVN remove failed.", e.getMessage(), false);
            return removeScmResult;
        }
        finally {
            javaRepo.getClientManager().getWCClient().setEventHandler(null);
        }
    }
}

