/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnjava.command.checkout;

import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.SvnTagBranchUtils;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnjava.repository.SvnJavaScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnjava.util.ScmFileEventHandler;
import org.apache.maven.scm.provider.svn.svnjava.util.SvnJavaUtil;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;

public class SvnJavaCheckOutCommand
extends AbstractCheckOutCommand
implements SvnCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion tag, boolean recursive) throws ScmException {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("SVN checkout directory: " + fileSet.getBasedir().getAbsolutePath());
        }
        SvnScmProviderRepository repository = (SvnScmProviderRepository)repo;
        String url = repository.getUrl();
        if (tag != null) {
            url = SvnTagBranchUtils.resolveTagUrl((SvnScmProviderRepository)repository, (ScmTag)new ScmTag(tag.getName()));
        }
        SvnJavaScmProviderRepository javaRepo = (SvnJavaScmProviderRepository)repo;
        ScmFileEventHandler handler = new ScmFileEventHandler(this.getLogger(), fileSet.getBasedir());
        SVNUpdateClient updateClient = javaRepo.getClientManager().getUpdateClient();
        updateClient.setEventHandler((ISVNEventHandler)handler);
        try {
            SvnJavaUtil.checkout(updateClient, SVNURL.parseURIEncoded((String)url), SVNRevision.HEAD, fileSet.getBasedir(), true);
            CheckOutScmResult checkOutScmResult = new CheckOutScmResult("JavaSVN Library", handler.getFiles());
            return checkOutScmResult;
        }
        catch (SVNException e) {
            CheckOutScmResult checkOutScmResult = new CheckOutScmResult("JavaSVN Library", "SVN checkout failed.", e.getMessage(), false);
            return checkOutScmResult;
        }
        finally {
            javaRepo.getClientManager().getUpdateClient().setEventHandler(null);
        }
    }
}

