/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnjava.command.add;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.add.AbstractAddCommand;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.svnjava.repository.SvnJavaScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnjava.util.SvnJavaUtil;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;

public class SvnJavaAddCommand
extends AbstractAddCommand
implements SvnCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScmResult executeAddCommand(ScmProviderRepository repository, ScmFileSet fileSet, String message, boolean binary) throws ScmException {
        if (fileSet.getFiles().length == 0) {
            throw new ScmException("You must provide at least one file/directory to add");
        }
        final ArrayList filesAdded = new ArrayList();
        SvnJavaScmProviderRepository javaRepo = (SvnJavaScmProviderRepository)repository;
        SVNClientManager clientManager = javaRepo.getClientManager();
        try {
            clientManager.getWCClient().setEventHandler(new ISVNEventHandler(){

                public void handleEvent(SVNEvent event, double progress) {
                    if (event.getAction() == SVNEventAction.ADD) {
                        filesAdded.add(event.getFile());
                    }
                }

                public void checkCancelled() throws SVNCancelException {
                }
            });
            File[] files = fileSet.getFiles();
            for (int i = 0; i < files.length; ++i) {
                File fileToAdd = new File(fileSet.getBasedir(), files[i].toString());
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("SVN adding file: " + fileToAdd.getAbsolutePath());
                }
                SvnJavaUtil.add(clientManager, fileToAdd, false);
            }
        }
        catch (SVNException e) {
            AddScmResult addScmResult = new AddScmResult("JavaSVN Library", "The svn operation failed.", e.getMessage(), false);
            return addScmResult;
        }
        finally {
            clientManager.getWCClient().setEventHandler(null);
        }
        return new AddScmResult(null, filesAdded);
    }
}

