/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.maven_replacer_plugin;

import com.google.code.maven_replacer_plugin.DelimiterBuilder;
import com.google.code.maven_replacer_plugin.file.FileUtils;
import java.io.IOException;
import org.apache.commons.lang.StringEscapeUtils;

public class Replacement {
    private final FileUtils fileUtils;
    private DelimiterBuilder delimiter;
    private boolean unescape;
    private String token;
    private String value;
    private String xpath;

    public Replacement() {
        this.fileUtils = new FileUtils();
        this.unescape = false;
    }

    public Replacement(FileUtils fileUtils, String token, String value, boolean unescape, String xpath) {
        this.fileUtils = fileUtils;
        this.setUnescape(unescape);
        this.setToken(token);
        this.setValue(value);
        this.setXpath(xpath);
    }

    public void setTokenFile(String tokenFile) throws IOException {
        if (tokenFile != null) {
            this.setToken(this.fileUtils.readFile(tokenFile));
        }
    }

    public void setValueFile(String valueFile) throws IOException {
        if (valueFile != null) {
            this.setValue(this.fileUtils.readFile(valueFile));
        }
    }

    public String getToken() {
        String newToken;
        String string = newToken = this.unescape ? this.unescape(this.token) : this.token;
        if (this.delimiter != null) {
            return this.delimiter.apply(newToken);
        }
        return newToken;
    }

    public String getValue() {
        return this.unescape ? this.unescape(this.value) : this.value;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setValue(String value) {
        this.value = value;
    }

    private String unescape(String text) {
        return StringEscapeUtils.unescapeJava((String)text);
    }

    public void setUnescape(boolean unescape) {
        this.unescape = unescape;
    }

    public boolean isUnescape() {
        return this.unescape;
    }

    public static Replacement from(Replacement replacement) {
        return new Replacement(replacement.fileUtils, replacement.token, replacement.value, replacement.unescape, replacement.xpath);
    }

    public Replacement withDelimiter(DelimiterBuilder delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    public String getXpath() {
        return this.xpath;
    }
}

