/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import net.sf.jsqlparser.expression.OracleHint;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.Distinct;
import net.sf.jsqlparser.statement.select.Fetch;
import net.sf.jsqlparser.statement.select.First;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.Offset;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.Skip;
import net.sf.jsqlparser.statement.select.Top;

public class PlainSelect
implements SelectBody {
    private Distinct distinct = null;
    private List<SelectItem> selectItems;
    private List<Table> intoTables;
    private FromItem fromItem;
    private List<Join> joins;
    private Expression where;
    private List<Expression> groupByColumnReferences;
    private List<OrderByElement> orderByElements;
    private Expression having;
    private Limit limit;
    private Offset offset;
    private Fetch fetch;
    private Skip skip;
    private First first;
    private Top top;
    private OracleHierarchicalExpression oracleHierarchical = null;
    private OracleHint oracleHint = null;
    private boolean oracleSiblings = false;
    private boolean forUpdate = false;
    private Table forUpdateTable = null;
    private boolean useBrackets = false;

    public boolean isUseBrackets() {
        return this.useBrackets;
    }

    public void setUseBrackets(boolean useBrackets) {
        this.useBrackets = useBrackets;
    }

    public FromItem getFromItem() {
        return this.fromItem;
    }

    public List<Table> getIntoTables() {
        return this.intoTables;
    }

    public List<SelectItem> getSelectItems() {
        return this.selectItems;
    }

    public Expression getWhere() {
        return this.where;
    }

    public void setFromItem(FromItem item) {
        this.fromItem = item;
    }

    public void setIntoTables(List<Table> intoTables) {
        this.intoTables = intoTables;
    }

    public void setSelectItems(List<SelectItem> list) {
        this.selectItems = list;
    }

    public void addSelectItems(SelectItem ... items) {
        if (this.selectItems == null) {
            this.selectItems = new ArrayList<SelectItem>();
        }
        Collections.addAll(this.selectItems, items);
    }

    public void setWhere(Expression where) {
        this.where = where;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public void setJoins(List<Join> list) {
        this.joins = list;
    }

    @Override
    public void accept(SelectVisitor selectVisitor) {
        selectVisitor.visit(this);
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.orderByElements = orderByElements;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public void setOffset(Offset offset) {
        this.offset = offset;
    }

    public Fetch getFetch() {
        return this.fetch;
    }

    public void setFetch(Fetch fetch) {
        this.fetch = fetch;
    }

    public Top getTop() {
        return this.top;
    }

    public void setTop(Top top) {
        this.top = top;
    }

    public Skip getSkip() {
        return this.skip;
    }

    public void setSkip(Skip skip) {
        this.skip = skip;
    }

    public First getFirst() {
        return this.first;
    }

    public void setFirst(First first) {
        this.first = first;
    }

    public Distinct getDistinct() {
        return this.distinct;
    }

    public void setDistinct(Distinct distinct) {
        this.distinct = distinct;
    }

    public Expression getHaving() {
        return this.having;
    }

    public void setHaving(Expression expression) {
        this.having = expression;
    }

    public List<Expression> getGroupByColumnReferences() {
        return this.groupByColumnReferences;
    }

    public void setGroupByColumnReferences(List<Expression> list) {
        this.groupByColumnReferences = list;
    }

    public void addGroupByColumnReference(Expression expr) {
        if (this.groupByColumnReferences == null) {
            this.groupByColumnReferences = new ArrayList<Expression>();
        }
        this.groupByColumnReferences.add(expr);
    }

    public OracleHierarchicalExpression getOracleHierarchical() {
        return this.oracleHierarchical;
    }

    public void setOracleHierarchical(OracleHierarchicalExpression oracleHierarchical) {
        this.oracleHierarchical = oracleHierarchical;
    }

    public boolean isOracleSiblings() {
        return this.oracleSiblings;
    }

    public void setOracleSiblings(boolean oracleSiblings) {
        this.oracleSiblings = oracleSiblings;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public void setForUpdate(boolean forUpdate) {
        this.forUpdate = forUpdate;
    }

    public Table getForUpdateTable() {
        return this.forUpdateTable;
    }

    public void setForUpdateTable(Table forUpdateTable) {
        this.forUpdateTable = forUpdateTable;
    }

    public OracleHint getOracleHint() {
        return this.oracleHint;
    }

    public void setOracleHint(OracleHint oracleHint) {
        this.oracleHint = oracleHint;
    }

    public String toString() {
        StringBuilder sql = new StringBuilder();
        if (this.useBrackets) {
            sql.append("(");
        }
        sql.append("SELECT ");
        if (this.oracleHint != null) {
            sql.append(this.oracleHint).append(" ");
        }
        if (this.skip != null) {
            sql.append(this.skip).append(" ");
        }
        if (this.first != null) {
            sql.append(this.first).append(" ");
        }
        if (this.distinct != null) {
            sql.append(this.distinct).append(" ");
        }
        if (this.top != null) {
            sql.append(this.top).append(" ");
        }
        sql.append(PlainSelect.getStringList(this.selectItems));
        if (this.intoTables != null) {
            sql.append(" INTO ");
            Iterator<Table> iter = this.intoTables.iterator();
            while (iter.hasNext()) {
                sql.append(iter.next().toString());
                if (!iter.hasNext()) continue;
                sql.append(", ");
            }
        }
        if (this.fromItem != null) {
            sql.append(" FROM ").append(this.fromItem);
            if (this.joins != null) {
                for (Join join : this.joins) {
                    if (join.isSimple()) {
                        sql.append(", ").append(join);
                        continue;
                    }
                    sql.append(" ").append(join);
                }
            }
            if (this.where != null) {
                sql.append(" WHERE ").append(this.where);
            }
            if (this.oracleHierarchical != null) {
                sql.append(this.oracleHierarchical.toString());
            }
            sql.append(PlainSelect.getFormatedList(this.groupByColumnReferences, "GROUP BY"));
            if (this.having != null) {
                sql.append(" HAVING ").append(this.having);
            }
            sql.append(PlainSelect.orderByToString(this.oracleSiblings, this.orderByElements));
            if (this.limit != null) {
                sql.append(this.limit);
            }
            if (this.offset != null) {
                sql.append(this.offset);
            }
            if (this.fetch != null) {
                sql.append(this.fetch);
            }
            if (this.isForUpdate()) {
                sql.append(" FOR UPDATE");
                if (this.forUpdateTable != null) {
                    sql.append(" OF ").append(this.forUpdateTable);
                }
            }
        } else if (this.where != null) {
            sql.append(" WHERE ").append(this.where);
        }
        if (this.useBrackets) {
            sql.append(")");
        }
        return sql.toString();
    }

    public static String orderByToString(List<OrderByElement> orderByElements) {
        return PlainSelect.orderByToString(false, orderByElements);
    }

    public static String orderByToString(boolean oracleSiblings, List<OrderByElement> orderByElements) {
        return PlainSelect.getFormatedList(orderByElements, oracleSiblings ? "ORDER SIBLINGS BY" : "ORDER BY");
    }

    public static String getFormatedList(List<?> list, String expression) {
        return PlainSelect.getFormatedList(list, expression, true, false);
    }

    public static String getFormatedList(List<?> list, String expression, boolean useComma, boolean useBrackets) {
        String sql = PlainSelect.getStringList(list, useComma, useBrackets);
        if (sql.length() > 0) {
            sql = expression.length() > 0 ? " " + expression + " " + sql : " " + sql;
        }
        return sql;
    }

    public static String getStringList(List<?> list) {
        return PlainSelect.getStringList(list, true, false);
    }

    public static String getStringList(List<?> list, boolean useComma, boolean useBrackets) {
        StringBuilder ans = new StringBuilder();
        String comma = ",";
        if (!useComma) {
            comma = "";
        }
        if (list != null) {
            if (useBrackets) {
                ans.append("(");
            }
            for (int i = 0; i < list.size(); ++i) {
                ans.append(list.get(i)).append(i < list.size() - 1 ? comma + " " : "");
            }
            if (useBrackets) {
                ans.append(")");
            }
        }
        return ans.toString();
    }
}

