/*
 * Decompiled with CFR 0.152.
 */
package com.github.javafaker;

import com.github.javafaker.Faker;
import java.math.BigDecimal;

public class Number {
    private final Faker faker;

    protected Number(Faker faker) {
        this.faker = faker;
    }

    public int randomDigit() {
        return this.decimalBetween(0L, 10L).intValue();
    }

    public int randomDigitNotZero() {
        return this.decimalBetween(1L, 10L).intValue();
    }

    public int numberBetween(int min, int max) {
        return this.decimalBetween(min, max).setScale(0, 5).intValue();
    }

    public long numberBetween(long min, long max) {
        return this.decimalBetween(min, max).longValue();
    }

    public long randomNumber(int numberOfDigits, boolean strict) {
        long max = (long)Math.pow(10.0, numberOfDigits);
        if (strict) {
            long min = (long)Math.pow(10.0, numberOfDigits - 1);
            return this.faker.random().nextLong(max - min) + min;
        }
        return this.faker.random().nextLong(max);
    }

    public long randomNumber() {
        int numberOfDigits = this.decimalBetween(1L, 10L).intValue();
        return this.randomNumber(numberOfDigits, false);
    }

    public double randomDouble(int maxNumberOfDecimals, int min, int max) {
        return this.randomDouble(maxNumberOfDecimals, (long)min, (long)max);
    }

    public double randomDouble(int maxNumberOfDecimals, long min, long max) {
        return this.decimalBetween(min, max).setScale(maxNumberOfDecimals, 5).doubleValue();
    }

    private BigDecimal decimalBetween(long min, long max) {
        double chunkCount;
        if (min == max) {
            return new BigDecimal(min);
        }
        long trueMin = Math.min(min, max);
        long trueMax = Math.max(min, max);
        double range = (double)trueMax - (double)trueMin;
        double chunkSize = chunkCount = Math.sqrt(Math.abs(range));
        long randomChunk = this.faker.random().nextLong((long)chunkCount);
        double chunkStart = (double)trueMin + (double)randomChunk * chunkSize;
        double adj = chunkSize * this.faker.random().nextDouble();
        return new BigDecimal(chunkStart + adj);
    }

    public String digits(int count) {
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            tmp.append(this.randomDigit());
        }
        return tmp.toString();
    }

    public String digit() {
        return this.digits(1);
    }
}

