/*
 * Decompiled with CFR 0.152.
 */
package sortpom;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import sortpom.SortPomImpl;
import sortpom.exception.ExceptionConverter;
import sortpom.logger.MavenLogger;
import sortpom.logger.SortPomLogger;
import sortpom.parameter.PluginParameters;
import sortpom.parameter.PluginParametersBuilder;

@Mojo(name="verify", threadSafe=true, defaultPhase=LifecyclePhase.VALIDATE)
public class VerifyMojo
extends AbstractMojo {
    @Parameter(property="sort.pomFile", defaultValue="${project.file}")
    private File pomFile;
    @Parameter(property="sort.predefinedSortOrder")
    private String predefinedSortOrder;
    @Parameter(property="sort.sortOrderFile")
    private String sortOrderFile;
    @Parameter(property="sort.sortDependencies")
    private String sortDependencies;
    @Parameter(property="sort.sortPlugins")
    private String sortPlugins;
    @Parameter(property="sort.sortProperties", defaultValue="false")
    private boolean sortProperties;
    @Parameter(property="sort.sortModules", defaultValue="false")
    private boolean sortModules;
    @Parameter(property="sort.encoding", defaultValue="UTF-8")
    private String encoding;
    @Parameter(property="sort.verifyFail", defaultValue="sort")
    private String verifyFail;
    @Parameter(property="sort.createBackupFile", defaultValue="true")
    private boolean createBackupFile;
    @Parameter(property="sort.backupFileExtension", defaultValue=".bak")
    private String backupFileExtension;
    @Parameter(property="sort.violationFilename")
    private String violationFilename;
    @Parameter(property="sort.lineSeparator", defaultValue="${line.separator}")
    private String lineSeparator;
    @Parameter(property="sort.expandEmptyElements", defaultValue="true")
    private boolean expandEmptyElements;
    @Parameter(property="sort.keepBlankLines", defaultValue="false")
    private boolean keepBlankLines;
    @Parameter(property="sort.nrOfIndentSpace", defaultValue="2")
    private int nrOfIndentSpace;
    @Parameter(property="sort.indentBlankLines", defaultValue="false")
    private boolean indentBlankLines;
    @Parameter(property="sort.skip", defaultValue="false")
    private boolean skip;
    private final SortPomImpl sortPomImpl = new SortPomImpl();

    public void execute() throws MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Sortpom");
        } else {
            this.setup();
            this.sortPom();
        }
    }

    public void setup() throws MojoFailureException {
        new ExceptionConverter(() -> {
            PluginParameters pluginParameters = new PluginParametersBuilder().setPomFile(this.pomFile).setFileOutput(this.createBackupFile, this.backupFileExtension, this.violationFilename).setEncoding(this.encoding).setFormatting(this.lineSeparator, this.expandEmptyElements, this.keepBlankLines).setIndent(this.nrOfIndentSpace, this.indentBlankLines).setSortOrder(this.sortOrderFile, this.predefinedSortOrder).setSortEntities(this.sortDependencies, this.sortPlugins, this.sortProperties, this.sortModules).setVerifyFail(this.verifyFail).createPluginParameters();
            this.sortPomImpl.setup((SortPomLogger)new MavenLogger(this.getLog()), pluginParameters);
        }).executeAndConvertException();
    }

    private void sortPom() throws MojoFailureException {
        new ExceptionConverter(() -> ((SortPomImpl)this.sortPomImpl).verifyPom()).executeAndConvertException();
    }
}

