/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.springsecurity;

import com.force.sdk.oauth.ForceUserPrincipal;
import com.force.sdk.oauth.connector.ForceOAuthConnector;
import com.force.sdk.oauth.context.SecurityContext;
import com.force.sdk.springsecurity.OAuthAuthenticationToken;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;

public class OAuthAuthenticationProvider
implements AuthenticationProvider {
    private static final Log LOGGER = LogFactory.getLog(OAuthAuthenticationProvider.class);
    private ForceOAuthConnector oauthConnector;

    public void setOauthConnector(ForceOAuthConnector oauthConnector) {
        this.oauthConnector = oauthConnector;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OAuthAuthenticationToken authToken = (OAuthAuthenticationToken)authentication;
        try {
            Object details = authToken.getDetails();
            SecurityContext sc = details instanceof SecurityContext ? (SecurityContext)details : this.oauthConnector.getAccessToken((String)authToken.getCredentials(), (String)authToken.getDetails());
            return OAuthAuthenticationProvider.createAuthentication(sc);
        }
        catch (IOException ie) {
            LOGGER.error((Object)"Unable to get access token", (Throwable)ie);
            throw new CredentialsExpiredException("OAuth login invalid or expired access token");
        }
    }

    public boolean supports(Class authentication) {
        return OAuthAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public static Authentication createAuthentication(SecurityContext sc) {
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        authorities.add((GrantedAuthority)new GrantedAuthorityImpl(sc.getRole()));
        OAuthAuthenticationToken newAuthToken = new OAuthAuthenticationToken((Principal)new ForceUserPrincipal(sc.getUserName(), sc.getSessionId()), null, authorities);
        newAuthToken.setDetails(sc.getForceSecurityContext());
        return newAuthToken;
    }
}

