/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.springsecurity;

import com.force.sdk.oauth.connector.ForceOAuthConnector;
import com.force.sdk.oauth.context.SecurityContextService;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class LogoutSuccessHandler
extends SimpleUrlLogoutSuccessHandler
implements InitializingBean {
    static final String FORCE_ENDPOINT_ATTRIBUTE = "__force_endpoint__";
    private boolean logoutFromForceDotCom;
    private ForceOAuthConnector oauthConnector;
    private SecurityContextService securityContextService;

    public void setLogoutFromForceDotCom(boolean logoutFromForceDotCom) {
        this.logoutFromForceDotCom = logoutFromForceDotCom;
    }

    public void setOauthConnector(ForceOAuthConnector oauthConnector) {
        this.oauthConnector = oauthConnector;
    }

    public void setSecurityContextService(SecurityContextService securityContextService) {
        this.securityContextService = securityContextService;
    }

    public void afterPropertiesSet() {
        if (this.logoutFromForceDotCom) {
            Assert.notNull((Object)this.oauthConnector, (String)"oauthConnector bean must be set");
            Assert.notNull((Object)this.securityContextService, (String)"securityContextService bean must be set");
        }
    }

    protected String determineTargetUrl(HttpServletRequest request, HttpServletResponse response) {
        if (this.isAlwaysUseDefaultTargetUrl()) {
            return this.getDefaultTargetUrl();
        }
        String targetUrl = request.getParameter(this.getTargetUrlParameter());
        if (StringUtils.hasLength((String)targetUrl)) {
            return targetUrl;
        }
        targetUrl = (String)request.getAttribute(FORCE_ENDPOINT_ATTRIBUTE);
        if (this.logoutFromForceDotCom && StringUtils.hasLength((String)targetUrl)) {
            return this.oauthConnector.getForceLogoutUrl(request, targetUrl, this.getDefaultTargetUrl());
        }
        return super.determineTargetUrl(request, response);
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        this.securityContextService.clearSecurityContext(request, response);
        super.onLogoutSuccess(request, response, authentication);
    }
}

