/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.springsecurity;

import com.force.sdk.oauth.connector.ForceOAuthConnector;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.util.Assert;

public class AuthenticationProcessingFilterEntryPoint
implements AuthenticationEntryPoint,
InitializingBean {
    private ForceOAuthConnector oauthConnector;

    public void setOauthConnector(ForceOAuthConnector oauthConnector) {
        this.oauthConnector = oauthConnector;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.oauthConnector, (String)"oauthConnector bean must be set");
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        response.sendRedirect(this.oauthConnector.getLoginRedirectUrl(request));
    }
}

