/*
 * Decompiled with CFR 0.152.
 */
package com.force.sdk.oauth.context;

import com.force.sdk.oauth.context.SecurityContext;
import com.sforce.soap.partner.Connector;
import com.sforce.soap.partner.GetUserInfoResult;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityContextUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityContextUtil.class);
    public static final String FORCE_FORCE_SESSION = "force_sid";
    public static final String FORCE_FORCE_ENDPOINT = "force_ep";
    public static final String DEFAULT_ROLE = "ROLE_USER";

    private SecurityContextUtil() {
    }

    public static Map<String, String> getCookieValues(HttpServletRequest request) {
        HashMap<String, String> cookieValueMap = new HashMap<String, String>();
        int totalCookieCount = 2;
        if (request.getCookies() != null) {
            int count = 0;
            for (Cookie cookie : request.getCookies()) {
                if (FORCE_FORCE_SESSION.equals(cookie.getName())) {
                    cookieValueMap.put(FORCE_FORCE_SESSION, cookie.getValue());
                    if (++count != totalCookieCount) continue;
                    break;
                }
                if (!FORCE_FORCE_ENDPOINT.equals(cookie.getName())) continue;
                try {
                    cookieValueMap.put(FORCE_FORCE_ENDPOINT, URLDecoder.decode(cookie.getValue(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error("Cannot retrieve endpoint information: ", (Throwable)e);
                }
                if (++count == totalCookieCount) break;
            }
        }
        return cookieValueMap;
    }

    public static void setCookieValues(SecurityContext sc, HttpServletResponse response, boolean secure) {
        HashMap<String, String> cookieValueMap = new HashMap<String, String>();
        cookieValueMap.put(FORCE_FORCE_SESSION, sc.getSessionId());
        try {
            cookieValueMap.put(FORCE_FORCE_ENDPOINT, URLEncoder.encode(sc.getEndPoint(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Cannot save endpoint information: ", (Throwable)e);
        }
        SecurityContextUtil.setCookieValues(cookieValueMap, response, secure);
    }

    public static void setCookieValues(Map<String, String> cookieValueMap, HttpServletResponse response, boolean secure) {
        for (Map.Entry<String, String> cookieEntry : cookieValueMap.entrySet()) {
            Cookie cookie = new Cookie(cookieEntry.getKey(), cookieEntry.getValue());
            cookie.setSecure(secure);
            response.addCookie(cookie);
        }
    }

    public static void clearCookieValues(HttpServletResponse response) {
        Cookie endPointClearCookie = new Cookie(FORCE_FORCE_ENDPOINT, "");
        Cookie sessionIdClearCookie = new Cookie(FORCE_FORCE_SESSION, "");
        endPointClearCookie.setMaxAge(0);
        sessionIdClearCookie.setMaxAge(0);
        response.addCookie(endPointClearCookie);
        response.addCookie(sessionIdClearCookie);
    }

    public static void initializeSecurityContextFromApi(SecurityContext securityContext) throws ConnectionException {
        ConnectorConfig config = new ConnectorConfig();
        config.setServiceEndpoint(securityContext.getEndPoint());
        config.setSessionId(securityContext.getSessionId());
        GetUserInfoResult userInfoResult = Connector.newConnection((ConnectorConfig)config).getUserInfo();
        securityContext.init(userInfoResult);
        SObject[] results = Connector.newConnection((ConnectorConfig)config).retrieve("Name", "Profile", new String[]{userInfoResult.getProfileId()});
        String role = null;
        if (results != null && results.length > 0) {
            SObject result = results[0];
            role = (String)result.getField("Name");
            if (role.isEmpty()) {
                role = DEFAULT_ROLE;
            }
        } else {
            role = DEFAULT_ROLE;
        }
        securityContext.setRole(role);
    }

    public static boolean useSecureCookies(HttpServletRequest request) {
        String hostHeader = request.getHeader("Host");
        boolean isLocalhostHeader = false;
        if (hostHeader != null && hostHeader.length() > 1 && hostHeader.contains(":")) {
            hostHeader = hostHeader.substring(0, hostHeader.indexOf(58));
        }
        if ("localhost".equals(hostHeader)) {
            isLocalhostHeader = true;
        }
        return !request.getLocalAddr().equals(request.getRemoteAddr()) && !isLocalhostHeader && !"127.0.0.1".equals(request.getLocalAddr()) && !"0.0.0.0".equals(request.getLocalAddr()) && !"0:0:0:0:0:0:0:1".equals(request.getLocalAddr());
    }
}

