/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.hibernate;

import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.ContextualSerializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.ResolvableSerializer;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.TypeSerializer;
import org.codehaus.jackson.type.JavaType;
import org.hibernate.collection.PersistentCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentCollectionSerializer
extends JsonSerializer<PersistentCollection>
implements ContextualSerializer<PersistentCollection>,
ResolvableSerializer {
    protected final BeanProperty _property;
    protected final boolean _forceLazyLoading;
    protected final JavaType _serializationType;
    protected JsonSerializer<Object> _serializer;

    public PersistentCollectionSerializer(BeanProperty property, JavaType type, boolean forceLazyLoading) {
        this._property = property;
        this._serializationType = type;
        this._forceLazyLoading = forceLazyLoading;
    }

    public JsonSerializer<PersistentCollection> createContextual(SerializationConfig config, BeanProperty property) throws JsonMappingException {
        if (property != null) {
            return new PersistentCollectionSerializer(property, property.getType(), this._forceLazyLoading);
        }
        return this;
    }

    public void resolve(SerializerProvider provider) throws JsonMappingException {
        this._serializer = provider.findValueSerializer(this._serializationType, this._property);
    }

    public void serialize(PersistentCollection coll, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (!this._forceLazyLoading && !coll.wasInitialized()) {
            jgen.writeNull();
            return;
        }
        Object value = coll.getValue();
        if (value == null) {
            provider.defaultSerializeNull(jgen);
        } else {
            if (this._serializer == null) {
                throw new JsonMappingException("PersitentCollection does not have serializer set");
            }
            this._serializer.serialize(value, jgen, provider);
        }
    }

    public void serializeWithType(PersistentCollection coll, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        if (!this._forceLazyLoading && !coll.wasInitialized()) {
            jgen.writeNull();
            return;
        }
        Object value = coll.getValue();
        if (value == null) {
            provider.defaultSerializeNull(jgen);
        } else {
            if (this._serializer == null) {
                throw new JsonMappingException("PersitentCollection does not have serializer set");
            }
            this._serializer.serializeWithType(value, jgen, provider, typeSer);
        }
    }
}

