/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.hibernate;

import com.fasterxml.jackson.module.hibernate.HibernateModule;
import com.fasterxml.jackson.module.hibernate.HibernateProxySerializer;
import com.fasterxml.jackson.module.hibernate.PersistentCollectionSerializer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.map.BeanDescription;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.Serializers;
import org.codehaus.jackson.map.TypeSerializer;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.type.MapType;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.type.JavaType;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.collection.PersistentMap;
import org.hibernate.proxy.HibernateProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateSerializers
extends Serializers.None {
    protected final int _moduleFeatures;

    public HibernateSerializers(int features) {
        this._moduleFeatures = features;
    }

    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc, BeanProperty beanProperty) {
        Class raw = type.getRawClass();
        if (PersistentCollection.class.isAssignableFrom(raw)) {
            // empty if block
        }
        if (HibernateProxy.class.isAssignableFrom(raw)) {
            return new HibernateProxySerializer(beanProperty, this.isEnabled(HibernateModule.Feature.FORCE_LAZY_LOADING));
        }
        return null;
    }

    public JsonSerializer<?> findCollectionSerializer(SerializationConfig config, CollectionType type, BeanDescription beanDesc, BeanProperty property, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        Class raw = type.getRawClass();
        if (PersistentCollection.class.isAssignableFrom(raw)) {
            return new PersistentCollectionSerializer(property, this._figureFallbackType(config, (JavaType)type), this.isEnabled(HibernateModule.Feature.FORCE_LAZY_LOADING));
        }
        return null;
    }

    public JsonSerializer<?> findMapSerializer(SerializationConfig config, MapType type, BeanDescription beanDesc, BeanProperty property, JsonSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        Class raw = type.getRawClass();
        if (PersistentMap.class.isAssignableFrom(raw)) {
            return new PersistentCollectionSerializer(property, this._figureFallbackType(config, (JavaType)type), this.isEnabled(HibernateModule.Feature.FORCE_LAZY_LOADING));
        }
        return null;
    }

    public final boolean isEnabled(HibernateModule.Feature f) {
        return (this._moduleFeatures & f.getMask()) != 0;
    }

    protected JavaType _figureFallbackType(SerializationConfig config, JavaType persistentType) {
        Class raw = persistentType.getRawClass();
        TypeFactory tf = config.getTypeFactory();
        if (Map.class.isAssignableFrom(raw)) {
            return tf.constructMapType(Map.class, Object.class, Object.class);
        }
        if (List.class.isAssignableFrom(raw)) {
            return tf.constructCollectionType(List.class, Object.class);
        }
        if (Set.class.isAssignableFrom(raw)) {
            return tf.constructCollectionType(Set.class, Object.class);
        }
        return tf.constructCollectionType(Collection.class, Object.class);
    }
}

