/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.hibernate;

import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.TypeSerializer;
import org.codehaus.jackson.map.ser.impl.PropertySerializerMap;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateProxySerializer
extends JsonSerializer<HibernateProxy> {
    protected final BeanProperty _property;
    protected final boolean _forceLazyLoading;
    protected PropertySerializerMap _dynamicSerializers;

    public HibernateProxySerializer(BeanProperty property, boolean forceLazyLoading) {
        this._property = property;
        this._forceLazyLoading = forceLazyLoading;
        this._dynamicSerializers = PropertySerializerMap.emptyMap();
    }

    public void serialize(HibernateProxy value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        Object proxiedValue = this.findProxied(value);
        if (proxiedValue == null) {
            provider.defaultSerializeNull(jgen);
            return;
        }
        this.findSerializer(provider, proxiedValue).serialize(proxiedValue, jgen, provider);
    }

    public void serializeWithType(HibernateProxy value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        Object proxiedValue = this.findProxied(value);
        if (proxiedValue == null) {
            provider.defaultSerializeNull(jgen);
            return;
        }
        this.findSerializer(provider, proxiedValue).serializeWithType(proxiedValue, jgen, provider, typeSer);
    }

    protected JsonSerializer<Object> findSerializer(SerializerProvider provider, Object value) throws IOException, JsonProcessingException {
        Class<?> type = value.getClass();
        PropertySerializerMap.SerializerAndMapResult result = this._dynamicSerializers.findAndAddSerializer(type, provider, this._property);
        if (this._dynamicSerializers != result.map) {
            this._dynamicSerializers = result.map;
        }
        return result.serializer;
    }

    protected Object findProxied(HibernateProxy proxy) {
        LazyInitializer init = proxy.getHibernateLazyInitializer();
        if (!this._forceLazyLoading && init.isUninitialized()) {
            return null;
        }
        return init.getImplementation();
    }
}

