/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DeserializerBase;
import java.io.IOException;
import java.time.Year;
import java.time.format.DateTimeFormatter;

public class YearDeserializer
extends JSR310DeserializerBase<Year> {
    private static final long serialVersionUID = 1L;
    private DateTimeFormatter formatter;
    public static final YearDeserializer INSTANCE = new YearDeserializer();

    private YearDeserializer() {
        super(Year.class);
    }

    public YearDeserializer(DateTimeFormatter formatter) {
        super(Year.class);
        this.formatter = formatter;
    }

    public Year deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        if (this.formatter == null) {
            return Year.of(parser.getValueAsInt());
        }
        return Year.parse(parser.getValueAsString(), this.formatter);
    }
}

