/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.NullsAsEmptyProvider;
import com.fasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import com.fasterxml.jackson.databind.deser.impl.NullsFailProvider;
import com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.util.AccessPattern;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;

public abstract class StdDeserializer<T>
extends JsonDeserializer<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int F_MASK_INT_COERCIONS = DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.getMask() | DeserializationFeature.USE_LONG_FOR_INTS.getMask();
    protected final Class<?> _valueClass;

    protected StdDeserializer(Class<?> vc) {
        this._valueClass = vc;
    }

    protected StdDeserializer(JavaType valueType) {
        this._valueClass = valueType.getRawClass();
    }

    protected StdDeserializer(StdDeserializer<?> src) {
        this._valueClass = src._valueClass;
    }

    @Override
    public Class<?> handledType() {
        return this._valueClass;
    }

    @Deprecated
    public final Class<?> getValueClass() {
        return this._valueClass;
    }

    public JavaType getValueType() {
        return null;
    }

    protected boolean isDefaultDeserializer(JsonDeserializer<?> deserializer) {
        return ClassUtil.isJacksonStdImpl(deserializer);
    }

    protected boolean isDefaultKeyDeserializer(KeyDeserializer keyDeser) {
        return ClassUtil.isJacksonStdImpl(keyDeser);
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromAny(p, ctxt);
    }

    protected final boolean _parseBooleanPrimitive(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return true;
        }
        if (t == JsonToken.VALUE_FALSE) {
            return false;
        }
        if (t == JsonToken.VALUE_NULL) {
            return false;
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return this._parseBooleanFromInt(p, ctxt);
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = p.getText().trim();
            if ("true".equals(text) || "True".equals(text)) {
                return true;
            }
            if ("false".equals(text) || "False".equals(text) || text.length() == 0) {
                return false;
            }
            if (this._hasTextualNull(text)) {
                return false;
            }
            Boolean b = (Boolean)ctxt.handleWeirdStringValue(this._valueClass, text, "only \"true\" or \"false\" recognized", new Object[0]);
            return b == null ? false : b;
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p.nextToken();
            boolean parsed = this._parseBooleanPrimitive(p, ctxt);
            t = p.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p, ctxt);
            }
            return parsed;
        }
        return (Boolean)ctxt.handleUnexpectedToken(this._valueClass, p);
    }

    protected boolean _parseBooleanFromInt(JsonParser p, DeserializationContext ctxt) throws IOException {
        return !"0".equals(p.getText());
    }

    protected final short _parseShortPrimitive(JsonParser p, DeserializationContext ctxt) throws IOException {
        int value = this._parseIntPrimitive(p, ctxt);
        if (this._shortOverflow(value)) {
            Number v = (Number)ctxt.handleWeirdStringValue(this._valueClass, String.valueOf(value), "overflow, value can not be represented as 16-bit value", new Object[0]);
            return v == null ? (short)0 : v.shortValue();
        }
        return (short)value;
    }

    protected final int _parseIntPrimitive(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            return p.getIntValue();
        }
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_STRING) {
            String text = p.getText().trim();
            if (this._hasTextualNull(text)) {
                return 0;
            }
            try {
                int len = text.length();
                if (len > 9) {
                    long l = Long.parseLong(text);
                    if (this._intOverflow(l)) {
                        Number v = (Number)ctxt.handleWeirdStringValue(this._valueClass, text, "Overflow: numeric value (%s) out of range of int (%d -%d)", text, Integer.MIN_VALUE, Integer.MAX_VALUE);
                        return v == null ? 0 : v.intValue();
                    }
                    return (int)l;
                }
                if (len == 0) {
                    return 0;
                }
                return NumberInput.parseInt((String)text);
            }
            catch (IllegalArgumentException iae) {
                Number v = (Number)ctxt.handleWeirdStringValue(this._valueClass, text, "not a valid int value", new Object[0]);
                return v == null ? 0 : v.intValue();
            }
        }
        if (t == JsonToken.VALUE_NUMBER_FLOAT) {
            if (!ctxt.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                this._failDoubleToIntCoercion(p, ctxt, "int");
            }
            return p.getValueAsInt();
        }
        if (t == JsonToken.VALUE_NULL) {
            return 0;
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p.nextToken();
            int parsed = this._parseIntPrimitive(p, ctxt);
            t = p.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p, ctxt);
            }
            return parsed;
        }
        return ((Number)ctxt.handleUnexpectedToken(this._valueClass, p)).intValue();
    }

    protected final long _parseLongPrimitive(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.getCurrentTokenId()) {
            case 7: {
                return p.getLongValue();
            }
            case 8: {
                if (!ctxt.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                    this._failDoubleToIntCoercion(p, ctxt, "long");
                }
                return p.getValueAsLong();
            }
            case 6: {
                String text = p.getText().trim();
                if (text.length() == 0 || this._hasTextualNull(text)) {
                    return 0L;
                }
                try {
                    return NumberInput.parseLong((String)text);
                }
                catch (IllegalArgumentException iae) {
                    Number v = (Number)ctxt.handleWeirdStringValue(this._valueClass, text, "not a valid long value", new Object[0]);
                    return v == null ? 0L : v.longValue();
                }
            }
            case 11: {
                return 0L;
            }
            case 3: {
                if (!ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                p.nextToken();
                long parsed = this._parseLongPrimitive(p, ctxt);
                JsonToken t = p.nextToken();
                if (t != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(p, ctxt);
                }
                return parsed;
            }
        }
        return ((Number)ctxt.handleUnexpectedToken(this._valueClass, p)).longValue();
    }

    protected final float _parseFloatPrimitive(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return p.getFloatValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = p.getText().trim();
            if (text.length() == 0 || this._hasTextualNull(text)) {
                return 0.0f;
            }
            switch (text.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(text)) break;
                    return Float.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!this._isNaN(text)) break;
                    return Float.NaN;
                }
                case '-': {
                    if (!this._isNegInf(text)) break;
                    return Float.NEGATIVE_INFINITY;
                }
            }
            try {
                return Float.parseFloat(text);
            }
            catch (IllegalArgumentException iae) {
                Number v = (Number)ctxt.handleWeirdStringValue(this._valueClass, text, "not a valid float value", new Object[0]);
                return v == null ? 0.0f : v.floatValue();
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return 0.0f;
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p.nextToken();
            float parsed = this._parseFloatPrimitive(p, ctxt);
            t = p.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p, ctxt);
            }
            return parsed;
        }
        return ((Number)ctxt.handleUnexpectedToken(this._valueClass, p)).floatValue();
    }

    protected final double _parseDoublePrimitive(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return p.getDoubleValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = p.getText().trim();
            if (text.length() == 0 || this._hasTextualNull(text)) {
                return 0.0;
            }
            switch (text.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(text)) break;
                    return Double.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!this._isNaN(text)) break;
                    return Double.NaN;
                }
                case '-': {
                    if (!this._isNegInf(text)) break;
                    return Double.NEGATIVE_INFINITY;
                }
            }
            try {
                return StdDeserializer.parseDouble(text);
            }
            catch (IllegalArgumentException iae) {
                Number v = (Number)ctxt.handleWeirdStringValue(this._valueClass, text, "not a valid double value", new Object[0]);
                return v == null ? 0.0 : v.doubleValue();
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return 0.0;
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p.nextToken();
            double parsed = this._parseDoublePrimitive(p, ctxt);
            t = p.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p, ctxt);
            }
            return parsed;
        }
        return ((Number)ctxt.handleUnexpectedToken(this._valueClass, p)).doubleValue();
    }

    protected Date _parseDate(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return new Date(p.getLongValue());
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Date)this.getNullValue(ctxt);
        }
        if (t == JsonToken.VALUE_STRING) {
            return this._parseDate(p.getText().trim(), ctxt);
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p.nextToken();
            Date parsed = this._parseDate(p, ctxt);
            t = p.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p, ctxt);
            }
            return parsed;
        }
        return (Date)ctxt.handleUnexpectedToken(this._valueClass, p);
    }

    protected Date _parseDate(String value, DeserializationContext ctxt) throws IOException {
        try {
            if (value.length() == 0 || this._hasTextualNull(value)) {
                return (Date)this.getNullValue(ctxt);
            }
            return ctxt.parseDate(value);
        }
        catch (IllegalArgumentException iae) {
            return (Date)ctxt.handleWeirdStringValue(this._valueClass, value, "not a valid representation (error: %s)", iae.getMessage());
        }
    }

    protected static final double parseDouble(String numStr) throws NumberFormatException {
        if ("2.2250738585072012e-308".equals(numStr)) {
            return Double.MIN_NORMAL;
        }
        return Double.parseDouble(numStr);
    }

    protected final String _parseString(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_STRING) {
            return p.getText();
        }
        String value = p.getValueAsString();
        if (value != null) {
            return value;
        }
        return (String)ctxt.handleUnexpectedToken(String.class, p);
    }

    protected T _deserializeFromEmpty(JsonParser p, DeserializationContext ctxt) throws IOException {
        String str;
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.START_ARRAY) {
            if (ctxt.isEnabled(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT)) {
                t = p.nextToken();
                if (t == JsonToken.END_ARRAY) {
                    return null;
                }
                return (T)ctxt.handleUnexpectedToken(this.handledType(), p);
            }
        } else if (t == JsonToken.VALUE_STRING && ctxt.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && (str = p.getText().trim()).isEmpty()) {
            return null;
        }
        return (T)ctxt.handleUnexpectedToken(this.handledType(), p);
    }

    protected boolean _hasTextualNull(String value) {
        return "null".equals(value);
    }

    protected final boolean _isNegInf(String text) {
        return "-Infinity".equals(text) || "-INF".equals(text);
    }

    protected final boolean _isPosInf(String text) {
        return "Infinity".equals(text) || "INF".equals(text);
    }

    protected final boolean _isNaN(String text) {
        return "NaN".equals(text);
    }

    protected Object _coerceIntegral(JsonParser p, DeserializationContext ctxt) throws IOException {
        int feats = ctxt.getDeserializationFeatures();
        if (DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.enabledIn(feats)) {
            return p.getBigIntegerValue();
        }
        if (DeserializationFeature.USE_LONG_FOR_INTS.enabledIn(feats)) {
            return p.getLongValue();
        }
        return p.getBigIntegerValue();
    }

    protected JsonDeserializer<Object> findDeserializer(DeserializationContext ctxt, JavaType type, BeanProperty property) throws JsonMappingException {
        return ctxt.findContextualValueDeserializer(type, property);
    }

    protected final boolean _isIntNumber(String text) {
        int len = text.length();
        if (len > 0) {
            int i;
            char c = text.charAt(0);
            int n = i = c == '-' || c == '+' ? 1 : 0;
            while (i < len) {
                char ch = text.charAt(i);
                if (ch > '9' || ch < '0') {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected JsonDeserializer<?> findConvertingContentDeserializer(DeserializationContext ctxt, BeanProperty prop, JsonDeserializer<?> existingDeserializer) throws JsonMappingException {
        Object convDef;
        AnnotatedMember member;
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        if (intr != null && prop != null && (member = prop.getMember()) != null && (convDef = intr.findDeserializationContentConverter(member)) != null) {
            Converter<Object, Object> conv = ctxt.converterInstance(prop.getMember(), convDef);
            JavaType delegateType = conv.getInputType(ctxt.getTypeFactory());
            if (existingDeserializer == null) {
                existingDeserializer = ctxt.findContextualValueDeserializer(delegateType, prop);
            }
            return new StdDelegatingDeserializer<Object>(conv, delegateType, existingDeserializer);
        }
        return existingDeserializer;
    }

    protected JsonFormat.Value findFormatOverrides(DeserializationContext ctxt, BeanProperty prop, Class<?> typeForDefaults) {
        if (prop != null) {
            return prop.findPropertyFormat(ctxt.getConfig(), typeForDefaults);
        }
        return ctxt.getDefaultPropertyFormat(typeForDefaults);
    }

    protected Boolean findFormatFeature(DeserializationContext ctxt, BeanProperty prop, Class<?> typeForDefaults, JsonFormat.Feature feat) {
        JsonFormat.Value format = this.findFormatOverrides(ctxt, prop, typeForDefaults);
        if (format != null) {
            return format.getFeature(feat);
        }
        return null;
    }

    protected final NullValueProvider findValueNullProvider(DeserializationContext ctxt, SettableBeanProperty prop, PropertyMetadata propMetadata) throws JsonMappingException {
        if (prop != null) {
            return this._findNullProvider(ctxt, prop, propMetadata.getValueNulls(), prop.getValueDeserializer());
        }
        return null;
    }

    protected NullValueProvider findContentNullProvider(DeserializationContext ctxt, BeanProperty prop, JsonDeserializer<?> valueDeser) throws JsonMappingException {
        JsonSetter.Nulls nulls = this.findContentNullStyle(ctxt, prop);
        if (nulls == JsonSetter.Nulls.SKIP) {
            return NullsConstantProvider.skipper();
        }
        NullValueProvider prov = this._findNullProvider(ctxt, prop, nulls, valueDeser);
        if (prov != null) {
            return prov;
        }
        return valueDeser;
    }

    protected JsonSetter.Nulls findContentNullStyle(DeserializationContext ctxt, BeanProperty prop) throws JsonMappingException {
        if (prop != null) {
            return prop.getMetadata().getContentNulls();
        }
        return null;
    }

    protected final NullValueProvider _findNullProvider(DeserializationContext ctxt, BeanProperty prop, JsonSetter.Nulls nulls, JsonDeserializer<?> valueDeser) throws JsonMappingException {
        if (nulls != null) {
            switch (nulls) {
                case FAIL: {
                    if (prop == null) {
                        return NullsFailProvider.constructForRootValue(ctxt.constructType(valueDeser.handledType()));
                    }
                    return NullsFailProvider.constructForProperty(prop);
                }
                case AS_EMPTY: {
                    AccessPattern access;
                    ValueInstantiator vi;
                    if (valueDeser == null) break;
                    if (valueDeser instanceof BeanDeserializerBase && !(vi = ((BeanDeserializerBase)valueDeser).getValueInstantiator()).canCreateUsingDefault()) {
                        JavaType type = prop.getType();
                        ctxt.reportBadDefinition(type, String.format("Can not create empty instance of %s, no default Creator", type));
                    }
                    if ((access = valueDeser.getEmptyAccessPattern()) == AccessPattern.ALWAYS_NULL) {
                        return NullsConstantProvider.nuller();
                    }
                    if (access == AccessPattern.CONSTANT) {
                        return NullsConstantProvider.forValue(valueDeser.getEmptyValue(ctxt));
                    }
                    return new NullsAsEmptyProvider(valueDeser);
                }
                case SKIP: {
                    return NullsConstantProvider.skipper();
                }
            }
        }
        return null;
    }

    protected void handleUnknownProperty(JsonParser p, DeserializationContext ctxt, Object instanceOrClass, String propName) throws IOException {
        if (instanceOrClass == null) {
            instanceOrClass = this.handledType();
        }
        if (ctxt.handleUnknownProperty(p, this, instanceOrClass, propName)) {
            return;
        }
        p.skipChildren();
    }

    protected void handleMissingEndArrayForSingle(JsonParser p, DeserializationContext ctxt) throws IOException {
        ctxt.reportWrongTokenException(this, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single '%s' value but there was more than a single value in the array", this.handledType().getName());
    }

    protected void _failDoubleToIntCoercion(JsonParser p, DeserializationContext ctxt, String type) throws IOException {
        ctxt.reportInputMismatch(this.handledType(), "Can not coerce a floating-point value ('%s') into %s; enable `DeserializationFeature.ACCEPT_FLOAT_AS_INT` to allow", p.getValueAsString(), type);
    }

    protected final boolean _byteOverflow(int value) {
        return value < -128 || value > 255;
    }

    protected final boolean _shortOverflow(int value) {
        return value < Short.MIN_VALUE || value > Short.MAX_VALUE;
    }

    protected final boolean _intOverflow(long value) {
        return value < Integer.MIN_VALUE || value > Integer.MAX_VALUE;
    }
}

