/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.common.utilities;

import com.datumbox.framework.common.dataobjects.AssociativeArray;
import com.datumbox.framework.common.dataobjects.TypeInference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class MapMethods {
    public static Map.Entry<Object, Object> selectMaxKeyValue(AssociativeArray keyValueMap) {
        Double maxValue = Double.NEGATIVE_INFINITY;
        Object maxValueKey = null;
        for (Map.Entry<Object, Object> entry : keyValueMap.entrySet()) {
            Double value = TypeInference.toDouble(entry.getValue());
            if (value == null || !(value > maxValue)) continue;
            maxValue = value;
            maxValueKey = entry.getKey();
        }
        return new AbstractMap.SimpleEntry<Object, Object>(maxValueKey, keyValueMap.get(maxValueKey));
    }

    public static Map.Entry<Object, Double> selectMaxKeyValue(Map<Object, Double> keyValueMap) {
        Double maxValue = Double.NEGATIVE_INFINITY;
        Object maxValueKey = null;
        for (Map.Entry<Object, Double> entry : keyValueMap.entrySet()) {
            Double value = entry.getValue();
            if (value == null || !(value > maxValue)) continue;
            maxValue = value;
            maxValueKey = entry.getKey();
        }
        return new AbstractMap.SimpleEntry<Object, Double>(maxValueKey, keyValueMap.get(maxValueKey));
    }

    public static Map.Entry<Object, Object> selectMinKeyValue(AssociativeArray keyValueMap) {
        Double minValue = Double.POSITIVE_INFINITY;
        Object minValueKey = null;
        for (Map.Entry<Object, Object> entry : keyValueMap.entrySet()) {
            Double value = TypeInference.toDouble(entry.getValue());
            if (value == null || !(value < minValue)) continue;
            minValue = value;
            minValueKey = entry.getKey();
        }
        return new AbstractMap.SimpleEntry<Object, Object>(minValueKey, keyValueMap.get(minValueKey));
    }

    public static Map.Entry<Object, Double> selectMinKeyValue(Map<Object, Double> keyValueMap) {
        Double minValue = Double.POSITIVE_INFINITY;
        Object minValueKey = null;
        for (Map.Entry<Object, Double> entry : keyValueMap.entrySet()) {
            Double value = entry.getValue();
            if (value == null || !(value < minValue)) continue;
            minValue = value;
            minValueKey = entry.getKey();
        }
        return new AbstractMap.SimpleEntry<Object, Double>(minValueKey, keyValueMap.get(minValueKey));
    }

    public static <K, V> Map<K, V> sortNumberMapByKeyAscending(Map<K, V> map) {
        return MapMethods.sortNumberMapByKeyAscending(map.entrySet());
    }

    public static <K, V> Map<K, V> sortNumberMapByKeyAscending(Set<Map.Entry<K, V>> entrySet) {
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>(entrySet);
        Collections.sort(entries, (a, b) -> {
            Double va = TypeInference.toDouble(a.getKey());
            Double vb = TypeInference.toDouble(b.getKey());
            return va.compareTo(vb);
        });
        LinkedHashMap<K, V> sortedMap = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry : entries) {
            sortedMap.put(entry.getKey(), entry.getValue());
        }
        return sortedMap;
    }

    public static <K, V> Map<K, V> sortNumberMapByKeyDescending(Map<K, V> map) {
        return MapMethods.sortNumberMapByKeyDescending(map.entrySet());
    }

    public static <K, V> Map<K, V> sortNumberMapByKeyDescending(Set<Map.Entry<K, V>> entrySet) {
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>(entrySet);
        Collections.sort(entries, (a, b) -> {
            Double va = TypeInference.toDouble(a.getKey());
            Double vb = TypeInference.toDouble(b.getKey());
            return -va.compareTo(vb);
        });
        LinkedHashMap<K, V> sortedMap = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry : entries) {
            sortedMap.put(entry.getKey(), entry.getValue());
        }
        return sortedMap;
    }

    public static <K, V> Map<K, V> sortNumberMapByValueAscending(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(entries, (a, b) -> {
            Double va = TypeInference.toDouble(a.getValue());
            Double vb = TypeInference.toDouble(b.getValue());
            return va.compareTo(vb);
        });
        LinkedHashMap<K, V> sortedMap = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry : entries) {
            sortedMap.put(entry.getKey(), entry.getValue());
        }
        return sortedMap;
    }

    public static <K, V> Map<K, V> sortNumberMapByValueDescending(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(entries, (a, b) -> {
            Double va = TypeInference.toDouble(a.getValue());
            Double vb = TypeInference.toDouble(b.getValue());
            return -va.compareTo(vb);
        });
        LinkedHashMap<K, V> sortedMap = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry : entries) {
            sortedMap.put(entry.getKey(), entry.getValue());
        }
        return sortedMap;
    }

    public static AssociativeArray sortAssociativeArrayByValueAscending(AssociativeArray associativeArray) {
        ArrayList<Map.Entry<Object, Object>> entries = new ArrayList<Map.Entry<Object, Object>>(associativeArray.entrySet());
        Collections.sort(entries, (a, b) -> {
            Double va = TypeInference.toDouble(a.getValue());
            Double vb = TypeInference.toDouble(b.getValue());
            return va.compareTo(vb);
        });
        AssociativeArray sortedAssociativeArray = new AssociativeArray();
        for (Map.Entry<Object, Object> entry : entries) {
            sortedAssociativeArray.put(entry.getKey(), entry.getValue());
        }
        return sortedAssociativeArray;
    }

    public static AssociativeArray sortAssociativeArrayByValueDescending(AssociativeArray associativeArray) {
        ArrayList<Map.Entry<Object, Object>> entries = new ArrayList<Map.Entry<Object, Object>>(associativeArray.entrySet());
        Collections.sort(entries, (a, b) -> {
            Double va = TypeInference.toDouble(a.getValue());
            Double vb = TypeInference.toDouble(b.getValue());
            return -va.compareTo(vb);
        });
        AssociativeArray sortedAssociativeArray = new AssociativeArray();
        for (Map.Entry<Object, Object> entry : entries) {
            sortedAssociativeArray.put(entry.getKey(), entry.getValue());
        }
        return sortedAssociativeArray;
    }
}

