/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.common.persistentstorage.mapdb;

import com.datumbox.framework.common.persistentstorage.abstracts.AbstractAutoCloseConnector;
import com.datumbox.framework.common.persistentstorage.interfaces.DatabaseConnector;
import com.datumbox.framework.common.persistentstorage.mapdb.MapDBConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.DBMaker;

public class MapDBConnector
extends AbstractAutoCloseConnector {
    private final String database;
    private final MapDBConfiguration dbConf;
    private final Map<DBType, DB> dbRegistry = new HashMap<DBType, DB>();

    protected MapDBConnector(String database, MapDBConfiguration dbConf) {
        this.database = database;
        this.dbConf = dbConf;
    }

    @Override
    public <T extends Serializable> void saveObject(String name, T serializableObject) {
        this.assertConnectionOpen();
        DB db = this.openDB(DBType.PRIMARY_DB);
        Atomic.Var atomicVar = db.getAtomicVar(name);
        atomicVar.set(serializableObject);
        db.commit();
    }

    @Override
    public <T extends Serializable> T loadObject(String name, Class<T> klass) {
        this.assertConnectionOpen();
        DB db = this.openDB(DBType.PRIMARY_DB);
        Atomic.Var atomicVar = db.getAtomicVar(name);
        return (T)((Serializable)klass.cast(atomicVar.get()));
    }

    @Override
    public void close() {
        super.close();
        this.closeDBRegistry();
    }

    @Override
    public void clear() {
        this.assertConnectionOpen();
        this.closeDBRegistry();
        try {
            Path defaultPath = this.getDefaultPath();
            Files.deleteIfExists(defaultPath);
            Files.deleteIfExists(Paths.get(defaultPath.toString() + ".p", new String[0]));
            Files.deleteIfExists(Paths.get(defaultPath.toString() + ".t", new String[0]));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public <K, V> Map<K, V> getBigMap(String name, DatabaseConnector.MapType type, DatabaseConnector.StorageHint storageHint, boolean isConcurrent, boolean isTemporary) {
        Object map;
        this.assertConnectionOpen();
        if (storageHint == DatabaseConnector.StorageHint.IN_MEMORY && this.dbConf.isHybridized()) {
            if (DatabaseConnector.MapType.HASHMAP.equals((Object)type)) {
                return isConcurrent ? new ConcurrentHashMap() : new HashMap();
            }
            if (DatabaseConnector.MapType.TREEMAP.equals((Object)type)) {
                return isConcurrent ? new ConcurrentSkipListMap() : new TreeMap();
            }
            throw new IllegalArgumentException("Unsupported MapType.");
        }
        DBType dbType = this.getDatabaseTypeFromName(name);
        if (dbType == null) {
            if (!isTemporary) {
                dbType = DBType.PRIMARY_DB;
            } else if (storageHint == DatabaseConnector.StorageHint.IN_MEMORY || storageHint == DatabaseConnector.StorageHint.IN_CACHE) {
                dbType = DBType.TEMP_DB_CACHED;
            } else if (storageHint == DatabaseConnector.StorageHint.IN_DISK) {
                dbType = DBType.TEMP_DB_UNCACHED;
            } else {
                throw new IllegalArgumentException("Unsupported StorageHint.");
            }
        }
        DB db = this.openDB(dbType);
        if (DatabaseConnector.MapType.HASHMAP.equals((Object)type)) {
            map = db.createHashMap(name).counterEnable().makeOrGet();
        } else if (DatabaseConnector.MapType.TREEMAP.equals((Object)type)) {
            map = db.createTreeMap(name).valuesOutsideNodesEnable().counterEnable().makeOrGet();
            if (isConcurrent) {
                map = Collections.synchronizedMap(map);
            }
        } else {
            throw new IllegalArgumentException("Unsupported MapType.");
        }
        return map;
    }

    @Override
    public <T extends Map> void dropBigMap(String name, T map) {
        this.assertConnectionOpen();
        DBType dbType = this.getDatabaseTypeFromName(name);
        if (dbType != null) {
            DB db = this.dbRegistry.get((Object)dbType);
            if (this.isOpenDB(db)) {
                db.delete(name);
            }
        } else {
            map.clear();
        }
    }

    @Override
    public String getDatabaseName() {
        return this.database;
    }

    private boolean isOpenDB(DB db) {
        return db != null && !db.isClosed();
    }

    private DB openDB(DBType dbType) {
        DB db = this.dbRegistry.get((Object)dbType);
        if (!this.isOpenDB(db)) {
            DBMaker m;
            boolean permitCaching = true;
            if (dbType == DBType.PRIMARY_DB) {
                m = DBMaker.newFileDB((File)this.getDefaultPath().toFile());
            } else if (dbType == DBType.TEMP_DB_CACHED || dbType == DBType.TEMP_DB_UNCACHED) {
                m = DBMaker.newTempFileDB().deleteFilesAfterClose();
                if (dbType == DBType.TEMP_DB_UNCACHED) {
                    permitCaching = false;
                }
            } else {
                throw new IllegalArgumentException("Unsupported DatabaseType.");
            }
            if (this.dbConf.isCompressed()) {
                m = m.compressionEnable();
            }
            m = permitCaching && this.dbConf.getCacheSize() > 0 ? m.cacheLRUEnable().cacheSize(this.dbConf.getCacheSize()) : m.cacheDisable();
            m = m.transactionDisable();
            m = m.asyncWriteEnable();
            m = m.closeOnJvmShutdown();
            db = m.make();
            this.dbRegistry.put(dbType, db);
        }
        return db;
    }

    private DBType getDatabaseTypeFromName(String name) {
        for (Map.Entry<DBType, DB> entry : this.dbRegistry.entrySet()) {
            DB db = entry.getValue();
            if (!this.isOpenDB(db) || !db.exists(name)) continue;
            return entry.getKey();
        }
        return null;
    }

    private void closeDBRegistry() {
        for (DB db : this.dbRegistry.values()) {
            if (!this.isOpenDB(db)) continue;
            db.close();
        }
        this.dbRegistry.clear();
    }

    private Path getDefaultPath() {
        String outputFolder = this.dbConf.getOutputFolder();
        if (outputFolder == null || outputFolder.isEmpty()) {
            outputFolder = System.getProperty("java.io.tmpdir");
        }
        return Paths.get(outputFolder + File.separator + this.database, new String[0]);
    }

    private static enum DBType {
        PRIMARY_DB,
        TEMP_DB_CACHED,
        TEMP_DB_UNCACHED;

    }
}

