/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.common.persistentstorage.mapdb;

import com.datumbox.framework.common.persistentstorage.interfaces.DatabaseConfiguration;
import com.datumbox.framework.common.persistentstorage.interfaces.DatabaseConnector;
import com.datumbox.framework.common.persistentstorage.mapdb.MapDBConnector;
import java.util.Properties;

public class MapDBConfiguration
implements DatabaseConfiguration {
    private static final String DBNAME_SEPARATOR = "_";
    private String outputFolder = null;
    private int cacheSize = 10000;
    private boolean compressed = true;
    private boolean hybridized = false;

    @Override
    public DatabaseConnector getConnector(String database) {
        return new MapDBConnector(database, this);
    }

    @Override
    public String getDBnameSeparator() {
        return DBNAME_SEPARATOR;
    }

    @Override
    public void load(Properties properties) {
        this.outputFolder = properties.getProperty("dbConfig.MapDBConfiguration.outputFolder");
        this.cacheSize = Integer.parseInt(properties.getProperty("dbConfig.MapDBConfiguration.cacheSize"));
        this.compressed = "true".equalsIgnoreCase(properties.getProperty("dbConfig.MapDBConfiguration.compressed"));
        this.hybridized = "true".equalsIgnoreCase(properties.getProperty("dbConfig.MapDBConfiguration.hybridized"));
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(String outputFolder) {
        this.outputFolder = outputFolder;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    public boolean isHybridized() {
        return this.hybridized;
    }

    public void setHybridized(boolean hybridized) {
        this.hybridized = hybridized;
    }
}

