/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.common.persistentstorage.inmemory;

import com.datumbox.framework.common.persistentstorage.abstracts.AbstractAutoCloseConnector;
import com.datumbox.framework.common.persistentstorage.inmemory.InMemoryConfiguration;
import com.datumbox.framework.common.persistentstorage.interfaces.DatabaseConnector;
import com.datumbox.framework.common.utilities.DeepCopy;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class InMemoryConnector
extends AbstractAutoCloseConnector {
    private final String database;
    private final InMemoryConfiguration dbConf;

    protected InMemoryConnector(String database, InMemoryConfiguration dbConf) {
        this.database = database;
        this.dbConf = dbConf;
    }

    @Override
    public <T extends Serializable> void saveObject(String name, T serializableObject) {
        this.assertConnectionOpen();
        try {
            Path defaultPath = this.getDefaultPath();
            Map storedObjects = Files.exists(defaultPath, new LinkOption[0]) ? (Map)DeepCopy.deserialize(Files.readAllBytes(defaultPath)) : new HashMap();
            storedObjects.put(name, serializableObject);
            Files.write(defaultPath, DeepCopy.serialize(storedObjects), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public <T extends Serializable> T loadObject(String name, Class<T> klass) {
        this.assertConnectionOpen();
        try {
            Map storedObjects = (Map)DeepCopy.deserialize(Files.readAllBytes(this.getDefaultPath()));
            return (T)((Serializable)klass.cast(storedObjects.get(name)));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public void close() {
        if (this.isClosed()) {
            return;
        }
        super.close();
    }

    @Override
    public void clear() {
        this.assertConnectionOpen();
        try {
            Files.deleteIfExists(this.getDefaultPath());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public <K, V> Map<K, V> getBigMap(String name, DatabaseConnector.MapType type, DatabaseConnector.StorageHint storageHint, boolean isConcurrent, boolean isTemporary) {
        this.assertConnectionOpen();
        if (DatabaseConnector.MapType.HASHMAP.equals((Object)type)) {
            return isConcurrent ? new ConcurrentHashMap() : new HashMap();
        }
        if (DatabaseConnector.MapType.TREEMAP.equals((Object)type)) {
            return isConcurrent ? new ConcurrentSkipListMap() : new TreeMap();
        }
        throw new IllegalArgumentException("Unsupported MapType.");
    }

    @Override
    public <T extends Map> void dropBigMap(String name, T map) {
        this.assertConnectionOpen();
        map.clear();
    }

    @Override
    public String getDatabaseName() {
        return this.database;
    }

    private Path getDefaultPath() {
        String outputFolder = this.dbConf.getOutputFolder();
        if (outputFolder == null || outputFolder.isEmpty()) {
            outputFolder = System.getProperty("java.io.tmpdir");
        }
        return Paths.get(outputFolder + File.separator + this.database, new String[0]);
    }
}

