/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.common.persistentstorage.abstracts;

import com.datumbox.framework.common.persistentstorage.interfaces.DatabaseConnector;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractAutoCloseConnector
implements DatabaseConnector {
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private Thread hook = new Thread(() -> {
        this.hook = null;
        if (this.isClosed()) {
            return;
        }
        this.close();
    });

    protected AbstractAutoCloseConnector() {
        Runtime.getRuntime().addShutdownHook(this.hook);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public void close() {
        if (!this.isClosed() && this.hook != null) {
            Runtime.getRuntime().removeShutdownHook(this.hook);
            this.hook = null;
        }
        this.isClosed.set(true);
    }

    protected void assertConnectionOpen() {
        if (this.isClosed()) {
            throw new RuntimeException("The connection is already closed.");
        }
    }
}

