/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.common.dataobjects;

import com.datumbox.framework.common.dataobjects.Dataframe;
import com.datumbox.framework.common.dataobjects.Record;
import com.datumbox.framework.common.dataobjects.TypeInference;
import java.util.Map;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.OpenMapRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

public class MatrixDataframe {
    private final RealMatrix X;
    private final RealVector Y;

    public RealMatrix getX() {
        return this.X;
    }

    public RealVector getY() {
        return this.Y;
    }

    private MatrixDataframe(RealMatrix X, RealVector Y) {
        this.Y = Y;
        this.X = X;
    }

    public static MatrixDataframe newInstance(Dataframe dataset, boolean addConstantColumn, Map<Integer, Integer> recordIdsReference, Map<Object, Integer> featureIdsReference) {
        if (!featureIdsReference.isEmpty()) {
            throw new IllegalArgumentException("The featureIdsReference map should be empty.");
        }
        int n = dataset.size();
        int d = dataset.xColumnSize();
        if (addConstantColumn) {
            ++d;
        }
        MatrixDataframe m = new MatrixDataframe((RealMatrix)new OpenMapRealMatrix(n, d), (RealVector)new ArrayRealVector(n));
        if (dataset.isEmpty()) {
            return m;
        }
        boolean extractY = dataset.getYDataType() == TypeInference.DataType.NUMERICAL;
        int featureId = 0;
        if (addConstantColumn) {
            for (int row = 0; row < n; ++row) {
                m.X.setEntry(row, featureId, 1.0);
            }
            featureIdsReference.put("~CONSTANT", featureId);
            ++featureId;
        }
        int rowId = 0;
        for (Map.Entry<Integer, Record> e : dataset.entries()) {
            Integer rId = e.getKey();
            Record r = e.getValue();
            if (recordIdsReference != null) {
                recordIdsReference.put(rId, rowId);
            }
            if (extractY) {
                m.Y.setEntry(rowId, TypeInference.toDouble(r.getY()).doubleValue());
            }
            for (Map.Entry<Object, Object> entry : r.getX().entrySet()) {
                Double value;
                Object feature = entry.getKey();
                Integer knownFeatureId = featureIdsReference.get(feature);
                if (knownFeatureId == null) {
                    featureIdsReference.put(feature, featureId);
                    knownFeatureId = featureId;
                    ++featureId;
                }
                if ((value = TypeInference.toDouble(entry.getValue())) == null) continue;
                m.X.setEntry(rowId, knownFeatureId.intValue(), value.doubleValue());
            }
            ++rowId;
        }
        return m;
    }

    public static MatrixDataframe parseDataset(Dataframe newData, Map<Integer, Integer> recordIdsReference, Map<Object, Integer> featureIdsReference) {
        if (featureIdsReference.isEmpty()) {
            throw new IllegalArgumentException("The featureIdsReference map should not be empty.");
        }
        int n = newData.size();
        int d = featureIdsReference.size();
        MatrixDataframe m = new MatrixDataframe((RealMatrix)new OpenMapRealMatrix(n, d), (RealVector)new ArrayRealVector(n));
        if (newData.isEmpty()) {
            return m;
        }
        boolean extractY = newData.getYDataType() == TypeInference.DataType.NUMERICAL;
        boolean addConstantColumn = featureIdsReference.containsKey("~CONSTANT");
        int rowId = 0;
        for (Map.Entry<Integer, Record> e : newData.entries()) {
            Integer rId = e.getKey();
            Record r = e.getValue();
            if (recordIdsReference != null) {
                recordIdsReference.put(rId, rowId);
            }
            if (extractY) {
                m.Y.setEntry(rowId, TypeInference.toDouble(r.getY()).doubleValue());
            }
            if (addConstantColumn) {
                m.X.setEntry(rowId, 0, 1.0);
            }
            for (Map.Entry<Object, Object> entry : r.getX().entrySet()) {
                Integer featureId;
                Object feature = entry.getKey();
                Double value = TypeInference.toDouble(entry.getValue());
                if (value == null || (featureId = featureIdsReference.get(feature)) == null) continue;
                m.X.setEntry(rowId, featureId.intValue(), value.doubleValue());
            }
            ++rowId;
        }
        return m;
    }

    public static RealVector parseRecord(Record r, Map<Object, Integer> featureIdsReference) {
        if (featureIdsReference.isEmpty()) {
            throw new IllegalArgumentException("The featureIdsReference map should not be empty.");
        }
        int d = featureIdsReference.size();
        ArrayRealVector v = new ArrayRealVector(d);
        boolean addConstantColumn = featureIdsReference.containsKey("~CONSTANT");
        if (addConstantColumn) {
            v.setEntry(0, 1.0);
        }
        for (Map.Entry<Object, Object> entry : r.getX().entrySet()) {
            Integer featureId;
            Object feature = entry.getKey();
            Double value = TypeInference.toDouble(entry.getValue());
            if (value == null || (featureId = featureIdsReference.get(feature)) == null) continue;
            v.setEntry(featureId.intValue(), value.doubleValue());
        }
        return v;
    }
}

