/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.common.concurrency;

import com.datumbox.framework.common.concurrency.ConcurrencyConfiguration;
import com.datumbox.framework.common.concurrency.ThreadMethods;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;

public class ForkJoinStream {
    private final ConcurrencyConfiguration concurrencyConfig;

    public ForkJoinStream(ConcurrencyConfiguration concurrencyConfig) {
        this.concurrencyConfig = concurrencyConfig;
    }

    public <T> void forEach(Stream<T> stream, Consumer<? super T> action) {
        Runnable runnable = () -> stream.forEach(action);
        ThreadMethods.forkJoinExecution(runnable, this.concurrencyConfig, stream.isParallel());
    }

    public <T, R> Stream<R> map(Stream<T> stream, Function<? super T, ? extends R> mapper) {
        Callable<Stream> callable = () -> stream.map(mapper);
        return ThreadMethods.forkJoinExecution(callable, this.concurrencyConfig, stream.isParallel());
    }

    public <T, R, A> R collect(Stream<T> stream, Collector<? super T, A, R> collector) {
        Callable<Object> callable = () -> stream.collect(collector);
        return (R)ThreadMethods.forkJoinExecution(callable, this.concurrencyConfig, stream.isParallel());
    }

    public <T> Optional<T> min(Stream<T> stream, Comparator<? super T> comparator) {
        Callable<Optional> callable = () -> stream.min(comparator);
        return ThreadMethods.forkJoinExecution(callable, this.concurrencyConfig, stream.isParallel());
    }

    public <T> Optional<T> max(Stream<T> stream, Comparator<? super T> comparator) {
        Callable<Optional> callable = () -> stream.max(comparator);
        return ThreadMethods.forkJoinExecution(callable, this.concurrencyConfig, stream.isParallel());
    }

    public double sum(DoubleStream stream) {
        Callable<Double> callable = () -> stream.sum();
        return ThreadMethods.forkJoinExecution(callable, this.concurrencyConfig, stream.isParallel());
    }
}

