/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.common;

import com.datumbox.framework.common.ConfigurableFactory;
import com.datumbox.framework.common.concurrency.ConcurrencyConfiguration;
import com.datumbox.framework.common.interfaces.Configurable;
import com.datumbox.framework.common.persistentstorage.interfaces.DatabaseConfiguration;
import java.util.Properties;

public class Configuration
implements Configurable {
    private DatabaseConfiguration dbConfig;
    private ConcurrencyConfiguration concurrencyConfig;

    protected Configuration() {
    }

    public DatabaseConfiguration getDbConfig() {
        return this.dbConfig;
    }

    public void setDbConfig(DatabaseConfiguration dbConfig) {
        this.dbConfig = dbConfig;
    }

    public ConcurrencyConfiguration getConcurrencyConfig() {
        return this.concurrencyConfig;
    }

    public void setConcurrencyConfig(ConcurrencyConfiguration concurrencyConfig) {
        this.concurrencyConfig = concurrencyConfig;
    }

    @Override
    public void load(Properties properties) {
        String dbConfigClassName = properties.getProperty("dbConfig.className");
        try {
            this.dbConfig = (DatabaseConfiguration)ConfigurableFactory.getConfiguration(Class.forName(dbConfigClassName));
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        this.concurrencyConfig = ConfigurableFactory.getConfiguration(ConcurrencyConfiguration.class);
    }

    public static Configuration getConfiguration() {
        return ConfigurableFactory.getConfiguration(Configuration.class);
    }
}

