/*
 * Decompiled with CFR 0.152.
 */
package com.datumbox.framework.common;

import com.datumbox.framework.common.interfaces.Configurable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;

public class ConfigurableFactory {
    public static <C extends Configurable> C getConfiguration(Class<C> klass) {
        Throwable throwable;
        InputStream in;
        Configurable conf;
        try {
            Constructor<C> constructor = klass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            conf = (Configurable)constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        Properties properties = new Properties();
        ClassLoader cl = ConfigurableFactory.class.getClassLoader();
        try {
            in = cl.getResourceAsStream("datumbox.config.default.properties");
            throwable = null;
            try {
                properties.load(in);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        if (cl.getResource("datumbox.config.properties") != null) {
            try {
                in = cl.getResourceAsStream("datumbox.config.properties");
                throwable = null;
                try {
                    properties.load(in);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        conf.load(properties);
        return (C)conf;
    }
}

