/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.view.template;

import com.blade.exception.BladeException;
import com.blade.kit.Assert;
import com.blade.mvc.WebContext;
import com.blade.mvc.http.Request;
import com.blade.mvc.http.Response;
import com.blade.mvc.http.Session;
import com.blade.mvc.ui.ModelAndView;
import com.blade.mvc.ui.template.TemplateEngine;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import jetbrick.template.JetContext;
import jetbrick.template.JetEngine;
import jetbrick.template.JetGlobalContext;
import jetbrick.template.JetTemplate;
import jetbrick.template.resolver.GlobalResolver;

public class JetbrickTemplateEngine
implements TemplateEngine {
    private JetEngine jetEngine;
    private Properties config = new Properties();
    private String suffix = ".html";

    public JetbrickTemplateEngine() {
        this.config.put("jetx.template.suffix", this.suffix);
        Class bootClass = WebContext.blade().bootClass();
        if (null != bootClass) {
            this.config.put("jetx.autoscan.packages", bootClass.getPackage().getName());
        }
        String $classpathLoader = "jetbrick.template.loader.ClasspathResourceLoader";
        this.config.put("jetx.template.loaders", "$classpathLoader");
        this.config.put("$classpathLoader", $classpathLoader);
        this.config.put("$classpathLoader.root", "/templates/");
        this.config.put("$classpathLoader.reloadable", "true");
    }

    public JetbrickTemplateEngine(Properties config) {
        this.config = config;
        this.jetEngine = JetEngine.create((Properties)config);
    }

    public JetbrickTemplateEngine(String conf) {
        this.jetEngine = JetEngine.create((String)conf);
    }

    public JetbrickTemplateEngine(JetEngine jetEngine) {
        if (null == jetEngine) {
            throw new IllegalArgumentException("jetEngine must not be null");
        }
        this.jetEngine = jetEngine;
    }

    public void render(ModelAndView modelAndView, Writer writer) throws BladeException {
        if (null == this.jetEngine) {
            this.jetEngine = JetEngine.create((Properties)this.config);
        }
        Map modelMap = modelAndView.getModel();
        Request request = WebContext.request();
        Response response = WebContext.response();
        Session session = request.session();
        modelMap.putAll(request.attributes());
        if (null != session) {
            modelMap.putAll(session.attributes());
        }
        JetContext context = new JetContext(modelMap.size());
        context.putAll(modelMap);
        String templateName = modelAndView.getView().endsWith(this.suffix) ? modelAndView.getView() : modelAndView.getView() + this.suffix;
        try {
            JetTemplate template = this.jetEngine.getTemplate(templateName);
            template.render((Map)context, writer);
        }
        catch (Exception e) {
            Assert.throwException((Throwable)e);
        }
    }

    public JetEngine getJetEngine() {
        return this.jetEngine;
    }

    public void setJetEngine(JetEngine jetEngine) {
        this.jetEngine = jetEngine;
    }

    public JetGlobalContext getGlobalContext() {
        if (null == this.jetEngine) {
            this.jetEngine = JetEngine.create((Properties)this.config);
        }
        return this.jetEngine.getGlobalContext();
    }

    public GlobalResolver getGlobalResolver() {
        if (null == this.jetEngine) {
            this.jetEngine = JetEngine.create((Properties)this.config);
        }
        return this.jetEngine.getGlobalResolver();
    }

    public Properties getConfig() {
        return this.config;
    }

    public TemplateEngine addConfig(String key, String value) {
        this.config.put(key, value);
        return this;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }
}

