/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.wrapper;

import com.blade.kit.DateKit;
import com.blade.mvc.WebContext;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public class OutputStreamWrapper {
    private OutputStream outputStream;
    private File file;
    private ChannelHandlerContext ctx;

    public OutputStreamWrapper(OutputStream outputStream, File file, ChannelHandlerContext ctx) {
        this.outputStream = outputStream;
        this.file = file;
        this.ctx = ctx;
    }

    public File getFile() {
        return this.file;
    }

    public OutputStream getRaw() {
        return this.outputStream;
    }

    public void write(byte[] b) throws IOException {
        this.outputStream.write(b);
    }

    public void write(int b) throws IOException {
        this.outputStream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.flush();
            FileChannel file = new FileInputStream(this.file).getChannel();
            long fileLength = file.size();
            DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            httpResponse.headers().set("Content-Length", (Object)fileLength);
            httpResponse.headers().set("Date", (Object)DateKit.gmtDate());
            httpResponse.headers().set("Server", (Object)"blade/2.0.1");
            boolean keepAlive = WebContext.request().keepAlive();
            if (keepAlive) {
                httpResponse.headers().set("Connection", (Object)"keep-alive");
            }
            this.ctx.write((Object)httpResponse);
            this.ctx.write((Object)new DefaultFileRegion(file, 0L, fileLength), (ChannelPromise)this.ctx.newProgressivePromise());
            this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        }
        finally {
            if (null != this.outputStream) {
                this.outputStream.close();
            }
        }
    }
}

