/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.ui.template;

import com.blade.exception.BladeException;
import com.blade.kit.IOKit;
import com.blade.mvc.Const;
import com.blade.mvc.WebContext;
import com.blade.mvc.http.Request;
import com.blade.mvc.http.Session;
import com.blade.mvc.ui.ModelAndView;
import com.blade.mvc.ui.template.BladeTemplate;
import com.blade.mvc.ui.template.TemplateEngine;
import java.io.File;
import java.io.Writer;
import java.util.HashMap;

public class DefaultEngine
implements TemplateEngine {
    public static String TEMPLATE_PATH = "templates";

    @Override
    public void render(ModelAndView modelAndView, Writer writer) throws BladeException {
        String view = modelAndView.getView();
        String viewPath = Const.CLASSPATH + File.separator + TEMPLATE_PATH + File.separator + view;
        viewPath = viewPath.replace("//", "/");
        try {
            Request request = WebContext.request();
            String body = IOKit.readToString(viewPath);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.putAll(request.attributes());
            Session session = request.session();
            if (null != session) {
                attributes.putAll(session.attributes());
            }
            String result = BladeTemplate.template(body, attributes).fmt();
            writer.write(result);
        }
        catch (Exception e) {
            throw new BladeException(e);
        }
        finally {
            IOKit.closeQuietly(writer);
        }
    }
}

